/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"
#include "GRID_F.H"

#define DIMS lo_1,lo_2,lo_3,hi_1,hi_2,hi_3

c *************************************************************************
c ** MKDIVUCC **
c ** Define the RHS of the cell-centered divergence constraint 
c ***************************************************************

      subroutine FORT_MKDIVUCC(divu_src,u,rho,time,dx,DIMS)

      implicit none

      integer DIMS

      REAL_T  divu_src(lo_1  :hi_1  ,lo_2  :hi_2  ,lo_3  :hi_3  )
      REAL_T         u(lo_1-3:hi_1+3,lo_2-3:hi_2+3,lo_3-3:hi_3+3,3)
      REAL_T       rho(lo_1-3:hi_1+3,lo_2-3:hi_2+3,lo_3-3:hi_3+3)
      REAL_T  time
      REAL_T  dx(3)

c     Local variables
      integer i,j,k

      do k = lo_3,hi_3
      do j = lo_2,hi_2
      do i = lo_1,hi_1
        divu_src(i,j,k) = zero
      enddo
      enddo
      enddo

      return
      end

c *************************************************************************
c ** MKDIVUNOD **
c ** Define the RHS of the node-centered divergence constraint 
c ***************************************************************

      subroutine FORT_MKDIVUNOD(divu_src,u,rho,time,dx,DIMS)

      implicit none

      integer DIMS

      REAL_T  divu_src(lo_1  :hi_1+1,lo_2  :hi_2+1,lo_3  :hi_3+1)
      REAL_T         u(lo_1-3:hi_1+3,lo_2-3:hi_2+3,lo_3-3:hi_3+3,3)
      REAL_T       rho(lo_1-3:hi_1+3,lo_2-3:hi_2+3,lo_3-3:hi_3+3)
      REAL_T  time
      REAL_T  dx(3)

c     Local variables
      integer i,j,k 

      do k = lo_3,hi_3+1
      do j = lo_2,hi_2+1
      do i = lo_1,hi_1+1
        divu_src(i,j,k) = zero
      enddo
      enddo
      enddo

      return
      end
