/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2021 Univ. Grenoble Alpes, CNRS, Grenoble INP, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef COMPUTENEIGHBORVALUEACTION_H
#define COMPUTENEIGHBORVALUEACTION_H

#include <Action.h>

#include <ImageComponent.h>

class ComputeNeighborValueAction : public camitk::Action {

public:

    /// Default Constructor
    ComputeNeighborValueAction(camitk::ActionExtension*);

    /// Default Destructor
    virtual ~ComputeNeighborValueAction();

public slots:
    /** this method is automatically called when the action is triggered.
      * Call getTargets() method to get the list of components to use.
      * \note getTargets() is automatically filtered so that it only contains compatible components,
      * i.e., instances of ComputeNeighborValueAction (or a subclass).
      */
    virtual camitk::Action::ApplyStatus apply() override;

private:
    /// helper method to simplify the target component processing
    virtual void process(camitk::ImageComponent*);

    /// Compute the euclidean distance between point X1 (x1, y1, z1) and point X2 (x2, y2, z2)
    double distance(int x1, int x2, int y1, int y2, int z1, int z2);

};

#endif // COMPUTENEIGHBORVALUEACTION_H

