------------------------------------------------------------------------------
--                                                                          --
--                            GNAT2XML COMPONENTS                           --
--                                                                          --
--           G N A T 2 X M L . A D A _ T R E E S . S E L F _ R E P          --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                  Copyright (C) 2012-2013, AdaCore, Inc.                  --
--                                                                          --
-- Gnat2xml is free software; you can redistribute it and/or modify it      --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. Gnat2xml is distributed  in the hope  that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MER-      --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
-- The gnat2xml tool was derived from the Avatox sources.                   --
------------------------------------------------------------------------------

pragma Ada_2012;

package Ada_Trees.Self_Rep is

   --  Debug and test procedures

   procedure Put_Ada_Tree (Tree : Ada_Tree);
   --  Prints out the tree in the form of an Ada expression that if evaluated
   --  would reproduce the tree. Used for debugging.

   procedure Stdo;
   --  Set current output to standard output, so we can see the output of
   --  Put_Ada_Tree in the debugger. Used for debugging.

   procedure Put_Self_Rep (Tree : Ada_Tree);
   --  Prints out an Ada program that constructs the tree (using Ada code
   --  generated by Put_Ada_Tree_Agg) and then prints it out by calling
   --  Put_Self_Rep. If compiled and run, the Ada program should print a
   --  copy of its own source code. Used for testing.

   procedure Put_Regen_Ada (Tree : Ada_Tree);
   --  Prints out a program that converts the tree back into Ada code, and
   --  writes it to current output. Writes the program to current output.
   --  Used for testing.

end Ada_Trees.Self_Rep;
