/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:23:35 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.datatransfer.Clipboard;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureSegment;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.CSCSAlgorithm;
import uk.ac.sanger.artemis.plot.LineAttributes;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class CSCSAlgorithm_ESTest extends CSCSAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Object object0 = new Object();
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      cSCSAlgorithm0.setAlgorithmName("Reverse Corrected Scaled Chi Square");
      float[] floatArray0 = new float[3];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) 1;
      cSCSAlgorithm0.getDefaultStepSize(10);
      // Undeclared exception!
      try { 
        cSCSAlgorithm0.getValues(2, 1793, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource((EntryGroup) null);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      cSCSAlgorithm0.getDefaultWindowSize();
      cSCSAlgorithm0.getAverage();
      cSCSAlgorithm0.getDefaultMaxWindowSize();
      cSCSAlgorithm0.getDefaultWindowSize();
      cSCSAlgorithm0.getMaximumInternal();
      cSCSAlgorithm0.getAverage();
      float[] floatArray0 = new float[3];
      floatArray0[0] = (float) 2;
      cSCSAlgorithm0.getDefaultMaxWindowSize();
      floatArray0[1] = (float) 2;
      floatArray0[2] = (float) 2;
      // Undeclared exception!
      try { 
        cSCSAlgorithm0.getValues(2, 1, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("internal error - unknown location node type");
      byte[] byteArray0 = new byte[1];
      byteArray0[0] = (byte) (-1);
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 0, 1254, "fZhN");
      Bases bases1 = sequenceChangeEvent0.getBases();
      bases0.getACount();
      Strand strand0 = bases1.getReverseStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      FileSystemHandling.createFolder((EvoSuiteFile) null);
      cSCSAlgorithm0.getDefaultMaxWindowSize();
      cSCSAlgorithm0.getDefaultMaxWindowSize();
      cSCSAlgorithm0.getDefaultWindowSize();
      cSCSAlgorithm0.getDefaultMinWindowSize();
      cSCSAlgorithm0.getMaximumInternal();
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      cSCSAlgorithm0.setAlgorithmName("Reverse Corrected Scaled Chi Square");
      float[] floatArray0 = new float[3];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) 1;
      cSCSAlgorithm0.getDefaultStepSize(10);
      // Undeclared exception!
      try { 
        cSCSAlgorithm0.getValues(2, 1793, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      CSCSAlgorithm cSCSAlgorithm0 = null;
      try {
        cSCSAlgorithm0 = new CSCSAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.CSCSAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Bases bases1 = simpleEntryGroup0.getBases();
      Strand strand0 = bases1.getForwardStrand();
      Bases bases2 = strand0.getBases();
      Strand strand1 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases2).when(strand1).getBases();
      doReturn(true, true).when(strand1).isForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand1);
      cSCSAlgorithm0.getAverage();
      cSCSAlgorithm0.setAlgorithmName("4ib.:g)!#P74KF");
      int int0 = 179;
      cSCSAlgorithm0.setUserMin(2074.846F);
      cSCSAlgorithm0.getDefaultStepSize(179);
      cSCSAlgorithm0.getMinimumInternal();
      cSCSAlgorithm0.getMaximumInternal();
      float[] floatArray0 = new float[8];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 179;
      floatArray0[2] = (float) 2;
      floatArray0[3] = (float) 179;
      floatArray0[4] = 2074.846F;
      floatArray0[5] = (float) 1;
      floatArray0[6] = (float) 2;
      floatArray0[7] = (float) 2;
      // Undeclared exception!
      try { 
        cSCSAlgorithm0.getValues(179, 179, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 179 > end: 178
         //
         verifyException("uk.ac.sanger.artemis.plot.CSCSAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      cSCSAlgorithm0.getAverage();
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("Y^x");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, false).when(strand0).isForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      int int0 = 500;
      float[] floatArray0 = new float[6];
      cSCSAlgorithm0.setAlgorithmName("Y^x");
      floatArray0[0] = (float) 1;
      floatArray0[1] = (float) 500;
      // Undeclared exception!
      cSCSAlgorithm0.getValues((-891), 134217728, floatArray0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("internal error - unknown location node type");
      byte[] byteArray0 = new byte[1];
      byteArray0[0] = (byte) (-1);
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 0, 1254, "fZhN");
      Bases bases1 = sequenceChangeEvent0.getBases();
      bases0.getACount();
      Strand strand0 = bases1.getReverseStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      bases0.reverseComplement();
      FileSystemHandling.createFolder((EvoSuiteFile) null);
      // Undeclared exception!
      try { 
        cSCSAlgorithm0.getValues(3, 99, (float[]) null);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -2
         //
         verifyException("uk.ac.sanger.artemis.plot.CSCSAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("_4ka-M]LJp6azN2zv");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      cSCSAlgorithm0.setUserMaxMin(false);
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 1;
      cSCSAlgorithm0.setUserMin(1.0F);
      floatArray0[1] = (float) 2;
      cSCSAlgorithm0.getValues(101, 1302, floatArray0);
      cSCSAlgorithm0.getMaximumInternal();
      cSCSAlgorithm0.getMinimumInternal();
      cSCSAlgorithm0.getMinimumInternal();
      floatArray0[2] = (float) 2;
      floatArray0[3] = (float) 1;
      float[] floatArray1 = new float[8];
      floatArray1[2] = (float) 0;
      floatArray1[5] = (float) 103;
      cSCSAlgorithm0.getValues(57, 101, floatArray0);
      floatArray1[6] = (float) (-1320);
      // Undeclared exception!
      try { 
        cSCSAlgorithm0.getValues(1302, 103, floatArray1);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 1302 > end: 104
         //
         verifyException("uk.ac.sanger.artemis.plot.CSCSAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("internal error - unknown location node type");
      byte[] byteArray0 = new byte[1];
      byteArray0[0] = (byte) (-1);
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 0, 1254, "fZhN");
      Bases bases1 = sequenceChangeEvent0.getBases();
      bases0.getACount();
      Strand strand0 = bases1.getReverseStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      FileSystemHandling.createFolder((EvoSuiteFile) null);
      // Undeclared exception!
      try { 
        cSCSAlgorithm0.getValues(3, 34, (float[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.CSCSAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      cSCSAlgorithm0.max_min_disabled = true;
      cSCSAlgorithm0.getDefaultMinWindowSize();
      cSCSAlgorithm0.max_min_disabled = false;
      cSCSAlgorithm0.getAverage();
      cSCSAlgorithm0.getAverage();
      cSCSAlgorithm0.getDefaultMaxWindowSize();
      cSCSAlgorithm0.getDefaultMaxWindowSize();
      cSCSAlgorithm0.getDefaultWindowSize();
      cSCSAlgorithm0.getDefaultStepSize(1);
      cSCSAlgorithm0.getMaximumInternal();
      cSCSAlgorithm0.getDefaultMinWindowSize();
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(true, false).when(strand0).isForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      cSCSAlgorithm0.getDefaultMinWindowSize();
      cSCSAlgorithm0.setUserMax(1.297F);
      cSCSAlgorithm0.getDefaultMaxWindowSize();
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.getBases();
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      cSCSAlgorithm0.getDefaultMaxWindowSize();
      cSCSAlgorithm0.setScalingFlag(false);
      cSCSAlgorithm0.getDefaultWindowSize();
      cSCSAlgorithm0.max_min_disabled = false;
      cSCSAlgorithm0.setUserMin(1.5F);
      cSCSAlgorithm0.getDefaultMinWindowSize();
      cSCSAlgorithm0.getValueCount();
      cSCSAlgorithm0.getValueCount();
      cSCSAlgorithm0.getDefaultStepSize(3);
      Graphics graphics0 = mock(Graphics.class, new ViolatedAssumptionAnswer());
      Color[] colorArray0 = new Color[6];
      Color color0 = mock(Color.class, new ViolatedAssumptionAnswer());
      colorArray0[0] = color0;
      colorArray0[1] = color0;
      colorArray0[2] = color0;
      colorArray0[3] = color0;
      colorArray0[4] = color0;
      colorArray0[5] = color0;
      cSCSAlgorithm0.drawLegend(graphics0, 0, 0, colorArray0);
      cSCSAlgorithm0.getDefaultStepSize(2617);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      float[] floatArray0 = new float[8];
      floatArray0[0] = (float) 2;
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("_4ka-M]LJp6azN2zv");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      cSCSAlgorithm0.setUserMaxMin(false);
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 1;
      cSCSAlgorithm0.setUserMin(2405.0F);
      floatArray0[1] = (float) 2;
      cSCSAlgorithm0.getValues(101, 1302, floatArray0);
      cSCSAlgorithm0.getMaximumInternal();
      cSCSAlgorithm0.getMinimumInternal();
      cSCSAlgorithm0.getMinimumInternal();
      floatArray0[2] = (float) 2;
      Range range0 = new Range((-1320));
      FeatureSegment featureSegment0 = null;
      try {
        featureSegment0 = new FeatureSegment((Feature) null, range0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FeatureSegment", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("internal error - unknown location node type");
      byte[] byteArray0 = new byte[1];
      byteArray0[0] = (byte) (-1);
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 0, 1254, "fZhN");
      Bases bases1 = sequenceChangeEvent0.getBases();
      bases0.getACount();
      Strand strand0 = bases1.getReverseStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      FileSystemHandling.createFolder((EvoSuiteFile) null);
      // Undeclared exception!
      try { 
        cSCSAlgorithm0.getValues(3, 99, (float[]) null);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1
         //
         verifyException("uk.ac.sanger.artemis.plot.CSCSAlgorithm", e);
      }
  }
}
