# FindDNET search and find the libdnet library path
#
# Usage:
#
#  find_package(DNET)
#  ...
#  target_link_libraries(... ${DNET_LIB})
#
# The following variables are to be set:
#   CMAKE_INCLUDE_PATH - find the dnet.h or dumbnet.h
#   CMAKE_LIBRARY_PATH - find the library
#
# Variable defined by this module:
#   DNET_INCLUDE_DIR - header directory
#   DNET_LIB         - library to link
#
# Copyright 2014 <Giuseppe Marco Randazzo> gmrandazzo@gmail.com
#
# Redistribution AND use is allowed according to the terms of the BSD 3 clause

set(libdnet_h dumbnet.h dnet.h)
set(libdnet_names dumbnet dnet)

foreach(header ${libdnet_h})
  find_path(DNET_INCLUDE_DIR  NAMES ${header} HINTS ${CMAKE_INCLUDE_PATH})
  if(DNET_INCLUDE_DIR)
    break()
  endif(DNET_INCLUDE_DIR)
endforeach(header ${libdnet_h})

foreach(libname ${libdnet_names})
  find_library(DNET_LIB NAMES ${libname} HINTS ${CMAKE_LIBRARY_PATH})
  if(DNET_LIB)
    break()
  endif(DNET_LIB)
endforeach(libname ${libdnet_names})

if(DNET_INCLUDE_DIR AND DNET_LIB)
  message(STATUS "Found libdnet")
  include_directories(${DNET_INCLUDE_DIR})
else(DNET_INCLUDE_DIR AND DNET_LIB)
  message(FATAL_ERROR "Could not find libdnet! Please Visit: http://libdnet.sourceforge.net/ or see in the arpon 'INSTALL' file.")
endif(DNET_INCLUDE_DIR AND DNET_LIB)
