/* SPDX-License-Identifier: GPL-2.0+ OR BSD-3-Clause */
/*
 * Copyright (C) 2017-2024, STMicroelectronics - All Rights Reserved
 */

#ifndef _DT_BINDINGS_CLOCK_STM32MP15_CLKSRC_H_
#define _DT_BINDINGS_CLOCK_STM32MP15_CLKSRC_H_

#include <lib/utils_def.h>

#define CMD_DIV		0
#define CMD_MUX		1
#define CMD_CLK		2

#define CMD_ADDR_BIT	BIT(31)

#define CMD_SHIFT	26
#define CMD_MASK	GENMASK_32(31, 26)
#define CMD_DATA_MASK	GENMASK_32(25, 0)

#define DIV_ID_SHIFT	8
#define DIV_ID_MASK	GENMASK_32(15, 8)

#define DIV_DIVN_SHIFT	0
#define DIV_DIVN_MASK	GENMASK_32(7, 0)

#define MUX_ID_SHIFT	4
#define MUX_ID_MASK	GENMASK_32(11, 4)

#define MUX_SEL_SHIFT	0
#define MUX_SEL_MASK	GENMASK_32(3, 0)

#define CLK_ID_MASK	GENMASK_32(19, 11)
#define CLK_ID_SHIFT	11
#define CLK_ON_MASK	0x00000400
#define CLK_ON_SHIFT	10
#define CLK_DIV_MASK	GENMASK_32(9, 4)
#define CLK_DIV_SHIFT	4
#define CLK_SEL_MASK	GENMASK_32(3, 0)
#define CLK_SEL_SHIFT	0

#define DIV(div_id, div)	((CMD_DIV << CMD_SHIFT) |\
				 ((div_id) << DIV_ID_SHIFT) |\
				 (div))

#define CLKSRC(mux_id, sel)	((CMD_MUX << CMD_SHIFT) |\
				 ((mux_id) << MUX_ID_SHIFT) |\
				 (sel))

/* CLK output is enable */
#define CLK_SRC(clk_id, sel)	((CMD_CLK << CMD_SHIFT) |\
				 ((clk_id) << CLK_ID_SHIFT) |\
				 (sel) | CLK_ON_MASK)

#define CLK_DISABLED(clk_id)	((CMD_CLK << CMD_SHIFT) |\
				 ((clk_id) << CLK_ID_SHIFT))

#define CLK_ADDR_SHIFT		16
#define CLK_ADDR_MASK		GENMASK_32(30, 16)
#define CLK_ADDR_VAL_MASK	GENMASK_32(15, 0)

#define DIV_PLL1DIVP	0
#define DIV_PLL2DIVP	1
#define DIV_PLL2DIVQ	2
#define DIV_PLL2DIVR	3
#define DIV_PLL3DIVP	4
#define DIV_PLL3DIVQ	5
#define DIV_PLL3DIVR	6
#define DIV_PLL4DIVP	7
#define DIV_PLL4DIVQ	8
#define DIV_PLL4DIVR	9
#define DIV_MPU		10
#define DIV_AXI		11
#define DIV_MCU		12
#define DIV_APB1	13
#define DIV_APB2	14
#define DIV_APB3	15
#define DIV_APB4	16
#define DIV_APB5	17
#define DIV_RTC		19
#define DIV_MCO1	20
#define DIV_MCO2	21
#define DIV_HSI		22
#define DIV_TRACE	23
#define DIV_ETHPTP	24
#define DIV_NB		25

#define MUX_MPU		0
#define MUX_AXI		1
#define MUX_MCU		2
#define MUX_PLL12	3
#define MUX_PLL3	4
#define MUX_PLL4	5
#define MUX_CKPER	6
#define MUX_RTC		7
#define MUX_SDMMC12	8
#define MUX_SDMMC3	9
#define MUX_FMC		10
#define MUX_QSPI	11
#define MUX_RNG1	12
#define MUX_RNG2	13
#define MUX_USBPHY	14
#define MUX_USBO	15
#define MUX_STGEN	16
#define MUX_SPDIF	17
#define MUX_SPI2S1	18
#define MUX_SPI2S23	19
#define MUX_SPI45	20
#define MUX_SPI6	21
#define MUX_CEC		22
#define MUX_I2C12	23
#define MUX_I2C35	24
#define MUX_I2C46	25
#define MUX_LPTIM1	26
#define MUX_LPTIM23	27
#define MUX_LPTIM45	28
#define MUX_UART1	29
#define MUX_UART24	30
#define MUX_UART35	31
#define MUX_UART6	32
#define MUX_UART78	33
#define MUX_SAI1	34
#define MUX_SAI2	35
#define MUX_SAI3	36
#define MUX_SAI4	37
#define MUX_DSI		38
#define MUX_FDCAN	39
#define MUX_ADC		40
#define MUX_ETH		41
#define MUX_MCO1	42
#define MUX_MCO2	43
#define MUX_NB		44

/* PLL output is enable when x=1, with x=p,q or r */
#define PQR(p, q, r)	(((p) & 1) | (((q) & 1) << 1) | (((r) & 1) << 2))

/* st,clksrc: clock sources */
#define CLK_MPU_HSI		CLKSRC(MUX_MPU, 0)
#define CLK_MPU_HSE		CLKSRC(MUX_MPU, 1)
#define CLK_MPU_PLL1P		CLKSRC(MUX_MPU, 2)
#define CLK_MPU_PLL1P_DIV	CLKSRC(MUX_MPU, 3)

#define CLK_AXI_HSI		CLKSRC(MUX_AXI, 0)
#define CLK_AXI_HSE		CLKSRC(MUX_AXI, 1)
#define CLK_AXI_PLL2P		CLKSRC(MUX_AXI, 2)

#define CLK_MCU_HSI		CLKSRC(MUX_MCU, 0)
#define CLK_MCU_HSE		CLKSRC(MUX_MCU, 1)
#define CLK_MCU_CSI		CLKSRC(MUX_MCU, 2)
#define CLK_MCU_PLL3P		CLKSRC(MUX_MCU, 3)

#define CLK_PLL12_HSI		CLKSRC(MUX_PLL12, 0)
#define CLK_PLL12_HSE		CLKSRC(MUX_PLL12, 1)

#define CLK_PLL3_HSI		CLKSRC(MUX_PLL3, 0)
#define CLK_PLL3_HSE		CLKSRC(MUX_PLL3, 1)
#define CLK_PLL3_CSI		CLKSRC(MUX_PLL3, 2)

#define CLK_PLL4_HSI		CLKSRC(MUX_PLL4, 0)
#define CLK_PLL4_HSE		CLKSRC(MUX_PLL4, 1)
#define CLK_PLL4_CSI		CLKSRC(MUX_PLL4, 2)
#define CLK_PLL4_I2SCKIN	CLKSRC(MUX_PLL4, 3)

#define CLK_RTC_DISABLED	CLK_DISABLED(RTC)
#define CLK_RTC_LSE		CLK_SRC(RTC, 1)
#define CLK_RTC_LSI		CLK_SRC(RTC, 2)
#define CLK_RTC_HSE		CLK_SRC(RTC, 3)

/* Register addresses of MCO1 & MCO2 */
#define MCO1			0x800
#define MCO2			0x804

#define MCO_OFF			0
#define MCO_ON			1
#define MCO_STATUS_SHIFT	12

#define MCO_ON_CFG(addr, sel)	(CMD_ADDR_BIT |\
				((addr) << CLK_ADDR_SHIFT) |\
				(MCO_ON << MCO_STATUS_SHIFT) |\
				(sel))

#define MCO_OFF_CFG(addr)	(CMD_ADDR_BIT |\
				((addr) << CLK_ADDR_SHIFT) |\
				(MCO_OFF << MCO_STATUS_SHIFT))

#define CLK_MCO1_HSI		MCO_ON_CFG(MCO1, 0)
#define CLK_MCO1_HSE		MCO_ON_CFG(MCO1, 1)
#define CLK_MCO1_CSI		MCO_ON_CFG(MCO1, 2)
#define CLK_MCO1_LSI		MCO_ON_CFG(MCO1, 3)
#define CLK_MCO1_LSE		MCO_ON_CFG(MCO1, 4)
#define CLK_MCO1_DISABLED	MCO_OFF_CFG(MCO1)

#define CLK_MCO2_MPU		MCO_ON_CFG(MCO2, 0)
#define CLK_MCO2_AXI		MCO_ON_CFG(MCO2, 1)
#define CLK_MCO2_MCU		MCO_ON_CFG(MCO2, 2)
#define CLK_MCO2_PLL4		MCO_ON_CFG(MCO2, 3)
#define CLK_MCO2_HSE		MCO_ON_CFG(MCO2, 4)
#define CLK_MCO2_HSI		MCO_ON_CFG(MCO2, 5)
#define CLK_MCO2_DISABLED	MCO_OFF_CFG(MCO2)

#define CLK_I2C12_PCLK1		CLKSRC(MUX_I2C12, 0)
#define CLK_I2C12_PLL4R		CLKSRC(MUX_I2C12, 1)
#define CLK_I2C12_HSI		CLKSRC(MUX_I2C12, 2)
#define CLK_I2C12_CSI		CLKSRC(MUX_I2C12, 3)
#define CLK_I2C12_DISABLED	CLKSRC(MUX_I2C12, 7)

#define CLK_I2C35_PCLK1		CLKSRC(MUX_I2C35, 0)
#define CLK_I2C35_PLL4R		CLKSRC(MUX_I2C35, 1)
#define CLK_I2C35_HSI		CLKSRC(MUX_I2C35, 2)
#define CLK_I2C35_CSI		CLKSRC(MUX_I2C35, 3)
#define CLK_I2C35_DISABLED	CLKSRC(MUX_I2C35, 7)

#define CLK_I2C46_PCLK5		CLKSRC(MUX_I2C46, 0)
#define CLK_I2C46_PLL3Q		CLKSRC(MUX_I2C46, 1)
#define CLK_I2C46_HSI		CLKSRC(MUX_I2C46, 2)
#define CLK_I2C46_CSI		CLKSRC(MUX_I2C46, 3)
#define CLK_I2C46_DISABLED	CLKSRC(MUX_I2C46, 7)

#define CLK_SAI1_PLL4Q		CLKSRC(MUX_SAI1, 0)
#define CLK_SAI1_PLL3Q		CLKSRC(MUX_SAI1, 1)
#define CLK_SAI1_I2SCKIN	CLKSRC(MUX_SAI1, 2)
#define CLK_SAI1_CKPER		CLKSRC(MUX_SAI1, 3)
#define CLK_SAI1_PLL3R		CLKSRC(MUX_SAI1, 4)
#define CLK_SAI1_DISABLED	CLKSRC(MUX_SAI1, 7)

#define CLK_SAI2_PLL4Q		CLKSRC(MUX_SAI2, 0)
#define CLK_SAI2_PLL3Q		CLKSRC(MUX_SAI2, 1)
#define CLK_SAI2_I2SCKIN	CLKSRC(MUX_SAI2, 2)
#define CLK_SAI2_CKPER		CLKSRC(MUX_SAI2, 3)
#define CLK_SAI2_SPDIF		CLKSRC(MUX_SAI2, 4)
#define CLK_SAI2_PLL3R		CLKSRC(MUX_SAI2, 5)
#define CLK_SAI2_DISABLED	CLKSRC(MUX_SAI2, 7)

#define CLK_SAI3_PLL4Q		CLKSRC(MUX_SAI3, 0)
#define CLK_SAI3_PLL3Q		CLKSRC(MUX_SAI3, 1)
#define CLK_SAI3_I2SCKIN	CLKSRC(MUX_SAI3, 2)
#define CLK_SAI3_CKPER		CLKSRC(MUX_SAI3, 3)
#define CLK_SAI3_PLL3R		CLKSRC(MUX_SAI3, 4)
#define CLK_SAI3_DISABLED	CLKSRC(MUX_SAI3, 7)

#define CLK_SAI4_PLL4Q		CLKSRC(MUX_SAI4, 0)
#define CLK_SAI4_PLL3Q		CLKSRC(MUX_SAI4, 1)
#define CLK_SAI4_I2SCKIN	CLKSRC(MUX_SAI4, 2)
#define CLK_SAI4_CKPER		CLKSRC(MUX_SAI4, 3)
#define CLK_SAI4_PLL3R		CLKSRC(MUX_SAI4, 4)
#define CLK_SAI4_DISABLED	CLKSRC(MUX_SAI4, 7)

#define CLK_SPI2S1_PLL4P	CLKSRC(MUX_SPI2S1, 0)
#define CLK_SPI2S1_PLL3Q	CLKSRC(MUX_SPI2S1, 1)
#define CLK_SPI2S1_I2SCKIN	CLKSRC(MUX_SPI2S1, 2)
#define CLK_SPI2S1_CKPER	CLKSRC(MUX_SPI2S1, 3)
#define CLK_SPI2S1_PLL3R	CLKSRC(MUX_SPI2S1, 4)
#define CLK_SPI2S1_DISABLED	CLKSRC(MUX_SPI2S1, 7)

#define CLK_SPI2S23_PLL4P	CLKSRC(MUX_SPI2S23, 0)
#define CLK_SPI2S23_PLL3Q	CLKSRC(MUX_SPI2S23, 1)
#define CLK_SPI2S23_I2SCKIN	CLKSRC(MUX_SPI2S23, 2)
#define CLK_SPI2S23_CKPER	CLKSRC(MUX_SPI2S23, 3)
#define CLK_SPI2S23_PLL3R	CLKSRC(MUX_SPI2S23, 4)
#define CLK_SPI2S23_DISABLED	CLKSRC(MUX_SPI2S23, 7)

#define CLK_SPI45_PCLK2		CLKSRC(MUX_SPI45, 0)
#define CLK_SPI45_PLL4Q		CLKSRC(MUX_SPI45, 1)
#define CLK_SPI45_HSI		CLKSRC(MUX_SPI45, 2)
#define CLK_SPI45_CSI		CLKSRC(MUX_SPI45, 3)
#define CLK_SPI45_HSE		CLKSRC(MUX_SPI45, 4)
#define CLK_SPI45_DISABLED	CLKSRC(MUX_SPI45, 7)

#define CLK_SPI6_PCLK5		CLKSRC(MUX_SPI6, 0)
#define CLK_SPI6_PLL4Q		CLKSRC(MUX_SPI6, 1)
#define CLK_SPI6_HSI		CLKSRC(MUX_SPI6, 2)
#define CLK_SPI6_CSI		CLKSRC(MUX_SPI6, 3)
#define CLK_SPI6_HSE		CLKSRC(MUX_SPI6, 4)
#define CLK_SPI6_PLL3Q		CLKSRC(MUX_SPI6, 5)
#define CLK_SPI6_DISABLED	CLKSRC(MUX_SPI6, 7)

#define CLK_UART6_PCLK2		CLKSRC(MUX_UART6, 0)
#define CLK_UART6_PLL4Q		CLKSRC(MUX_UART6, 1)
#define CLK_UART6_HSI		CLKSRC(MUX_UART6, 2)
#define CLK_UART6_CSI		CLKSRC(MUX_UART6, 3)
#define CLK_UART6_HSE		CLKSRC(MUX_UART6, 4)
#define CLK_UART6_DISABLED	CLKSRC(MUX_UART6, 7)

#define CLK_UART24_PCLK1	CLKSRC(MUX_UART24, 0)
#define CLK_UART24_PLL4Q	CLKSRC(MUX_UART24, 1)
#define CLK_UART24_HSI		CLKSRC(MUX_UART24, 2)
#define CLK_UART24_CSI		CLKSRC(MUX_UART24, 3)
#define CLK_UART24_HSE		CLKSRC(MUX_UART24, 4)
#define CLK_UART24_DISABLED	CLKSRC(MUX_UART24, 7)

#define CLK_UART35_PCLK1	CLKSRC(MUX_UART35, 0)
#define CLK_UART35_PLL4Q	CLKSRC(MUX_UART35, 1)
#define CLK_UART35_HSI		CLKSRC(MUX_UART35, 2)
#define CLK_UART35_CSI		CLKSRC(MUX_UART35, 3)
#define CLK_UART35_HSE		CLKSRC(MUX_UART35, 4)
#define CLK_UART35_DISABLED	CLKSRC(MUX_UART35, 7)

#define CLK_UART78_PCLK1	CLKSRC(MUX_UART78, 0)
#define CLK_UART78_PLL4Q	CLKSRC(MUX_UART78, 1)
#define CLK_UART78_HSI		CLKSRC(MUX_UART78, 2)
#define CLK_UART78_CSI		CLKSRC(MUX_UART78, 3)
#define CLK_UART78_HSE		CLKSRC(MUX_UART78, 4)
#define CLK_UART78_DISABLED	CLKSRC(MUX_UART78, 7)

#define CLK_UART1_PCLK5		CLKSRC(MUX_UART1, 0)
#define CLK_UART1_PLL3Q		CLKSRC(MUX_UART1, 1)
#define CLK_UART1_HSI		CLKSRC(MUX_UART1, 2)
#define CLK_UART1_CSI		CLKSRC(MUX_UART1, 3)
#define CLK_UART1_PLL4Q		CLKSRC(MUX_UART1, 4)
#define CLK_UART1_HSE		CLKSRC(MUX_UART1, 5)
#define CLK_UART1_DISABLED	CLKSRC(MUX_UART1, 7)

#define CLK_SDMMC12_HCLK6	CLKSRC(MUX_SDMMC12, 0)
#define CLK_SDMMC12_PLL3R	CLKSRC(MUX_SDMMC12, 1)
#define CLK_SDMMC12_PLL4P	CLKSRC(MUX_SDMMC12, 2)
#define CLK_SDMMC12_HSI		CLKSRC(MUX_SDMMC12, 3)
#define CLK_SDMMC12_DISABLED	CLKSRC(MUX_SDMMC12, 7)

#define CLK_SDMMC3_HCLK2	CLKSRC(MUX_SDMMC3, 0)
#define CLK_SDMMC3_PLL3R	CLKSRC(MUX_SDMMC3, 1)
#define CLK_SDMMC3_PLL4P	CLKSRC(MUX_SDMMC3, 2)
#define CLK_SDMMC3_HSI		CLKSRC(MUX_SDMMC3, 3)
#define CLK_SDMMC3_DISABLED	CLKSRC(MUX_SDMMC3, 7)

#define CLK_ETH_PLL4P		CLKSRC(MUX_ETH, 0)
#define CLK_ETH_PLL3Q		CLKSRC(MUX_ETH, 1)
#define CLK_ETH_DISABLED	CLKSRC(MUX_ETH, 3)

#define CLK_QSPI_ACLK		CLKSRC(MUX_QSPI, 0)
#define CLK_QSPI_PLL3R		CLKSRC(MUX_QSPI, 1)
#define CLK_QSPI_PLL4P		CLKSRC(MUX_QSPI, 2)
#define CLK_QSPI_CKPER		CLKSRC(MUX_QSPI, 3)

#define CLK_FMC_ACLK		CLKSRC(MUX_FMC, 0)
#define CLK_FMC_PLL3R		CLKSRC(MUX_FMC, 1)
#define CLK_FMC_PLL4P		CLKSRC(MUX_FMC, 2)
#define CLK_FMC_CKPER		CLKSRC(MUX_FMC, 3)

#define CLK_FDCAN_HSE		CLKSRC(MUX_FDCAN, 0)
#define CLK_FDCAN_PLL3Q		CLKSRC(MUX_FDCAN, 1)
#define CLK_FDCAN_PLL4Q		CLKSRC(MUX_FDCAN, 2)
#define CLK_FDCAN_PLL4R		CLKSRC(MUX_FDCAN, 3)

#define CLK_SPDIF_PLL4P		CLKSRC(MUX_SPDIF, 0)
#define CLK_SPDIF_PLL3Q		CLKSRC(MUX_SPDIF, 1)
#define CLK_SPDIF_HSI		CLKSRC(MUX_SPDIF, 2)
#define CLK_SPDIF_DISABLED	CLKSRC(MUX_SPDIF, 3)

#define CLK_CEC_LSE		CLKSRC(MUX_CEC, 0)
#define CLK_CEC_LSI		CLKSRC(MUX_CEC, 1)
#define CLK_CEC_CSI_DIV122	CLKSRC(MUX_CEC, 2)
#define CLK_CEC_DISABLED	CLKSRC(MUX_CEC, 3)

#define CLK_USBPHY_HSE		CLKSRC(MUX_USBPHY, 0)
#define CLK_USBPHY_PLL4R	CLKSRC(MUX_USBPHY, 1)
#define CLK_USBPHY_HSE_DIV2	CLKSRC(MUX_USBPHY, 2)
#define CLK_USBPHY_DISABLED	CLKSRC(MUX_USBPHY, 3)

#define CLK_USBO_PLL4R		CLKSRC(MUX_USBO, 0)
#define CLK_USBO_USBPHY		CLKSRC(MUX_USBO, 1)

#define CLK_RNG1_CSI		CLKSRC(MUX_RNG1, 0)
#define CLK_RNG1_PLL4R		CLKSRC(MUX_RNG1, 1)
#define CLK_RNG1_LSE		CLKSRC(MUX_RNG1, 2)
#define CLK_RNG1_LSI		CLKSRC(MUX_RNG1, 3)

#define CLK_RNG2_CSI		CLKSRC(MUX_RNG2, 0)
#define CLK_RNG2_PLL4R		CLKSRC(MUX_RNG2, 1)
#define CLK_RNG2_LSE		CLKSRC(MUX_RNG2, 2)
#define CLK_RNG2_LSI		CLKSRC(MUX_RNG2, 3)

#define CLK_CKPER_HSI		CLKSRC(MUX_CKPER, 0)
#define CLK_CKPER_CSI		CLKSRC(MUX_CKPER, 1)
#define CLK_CKPER_HSE		CLKSRC(MUX_CKPER, 2)
#define CLK_CKPER_DISABLED	CLKSRC(MUX_CKPER, 3)

#define CLK_STGEN_HSI		CLKSRC(MUX_STGEN, 0)
#define CLK_STGEN_HSE		CLKSRC(MUX_STGEN, 1)
#define CLK_STGEN_DISABLED	CLKSRC(MUX_STGEN, 3)

#define CLK_DSI_DSIPLL		CLKSRC(MUX_DSI, 0)
#define CLK_DSI_PLL4P		CLKSRC(MUX_DSI, 1)

#define CLK_ADC_PLL4R		CLKSRC(MUX_ADC, 0)
#define CLK_ADC_CKPER		CLKSRC(MUX_ADC, 1)
#define CLK_ADC_PLL3Q		CLKSRC(MUX_ADC, 2)
#define CLK_ADC_DISABLED	CLKSRC(MUX_ADC, 3)

#define CLK_LPTIM45_PCLK3	CLKSRC(MUX_LPTIM45, 0)
#define CLK_LPTIM45_PLL4P	CLKSRC(MUX_LPTIM45, 1)
#define CLK_LPTIM45_PLL3Q	CLKSRC(MUX_LPTIM45, 2)
#define CLK_LPTIM45_LSE		CLKSRC(MUX_LPTIM45, 3)
#define CLK_LPTIM45_LSI		CLKSRC(MUX_LPTIM45, 4)
#define CLK_LPTIM45_CKPER	CLKSRC(MUX_LPTIM45, 5)
#define CLK_LPTIM45_DISABLED	CLKSRC(MUX_LPTIM45, 7)

#define CLK_LPTIM23_PCLK3	CLKSRC(MUX_LPTIM23, 0)
#define CLK_LPTIM23_PLL4Q	CLKSRC(MUX_LPTIM23, 1)
#define CLK_LPTIM23_CKPER	CLKSRC(MUX_LPTIM23, 2)
#define CLK_LPTIM23_LSE		CLKSRC(MUX_LPTIM23, 3)
#define CLK_LPTIM23_LSI		CLKSRC(MUX_LPTIM23, 4)
#define CLK_LPTIM23_DISABLED	CLKSRC(MUX_LPTIM23, 7)

#define CLK_LPTIM1_PCLK1	CLKSRC(MUX_LPTIM1, 0)
#define CLK_LPTIM1_PLL4P	CLKSRC(MUX_LPTIM1, 1)
#define CLK_LPTIM1_PLL3Q	CLKSRC(MUX_LPTIM1, 2)
#define CLK_LPTIM1_LSE		CLKSRC(MUX_LPTIM1, 3)
#define CLK_LPTIM1_LSI		CLKSRC(MUX_LPTIM1, 4)
#define CLK_LPTIM1_CKPER	CLKSRC(MUX_LPTIM1, 5)
#define CLK_LPTIM1_DISABLED	CLKSRC(MUX_LPTIM1, 7)

/* define for st,pll /csg */
#define SSCG_MODE_CENTER_SPREAD	0
#define SSCG_MODE_DOWN_SPREAD	1

/* define for st,drive */
#define LSEDRV_LOWEST		0
#define LSEDRV_MEDIUM_LOW	1
#define LSEDRV_MEDIUM_HIGH	2
#define LSEDRV_HIGHEST		3

#endif
