French and Arpitan: `apertium-fra-frp`
===============================================================================

This is an Apertium language pair for translating between French and
Arpitan. What you can use this language package for:

* Translating between French and Arpitan
* Morphological analysis of French and Arpitan
* Part-of-speech tagging of French and Arpitan

For information on the latter two points, see subheading "For more
information" below.

Requirements
-------------------------------------------------------------------------------

You will need the following software installed:

* lttoolbox (>= 3.3.0)
* apertium (>= 3.3.0)
* vislcg3 (>= 0.9.9.10297)
* apertium-fra
* apertium-frp

If this does not make any sense, we recommend you look at: www.apertium.org.

Compiling
-------------------------------------------------------------------------------

Given the requirements being installed, you should be able to just run:

```console
$ ./configure
$ make
# make install
```

You can use `./autogen.sh` instead of `./configure` in case you're compiling
from source. If you installed any prerequisite language packages using a
`--prefix` with `./configure`, make sure to use the same `--prefix` when running
`./configure` here.

Testing
-------------------------------------------------------------------------------

If you are in the source directory after running make, the following
commands should work:

```console
$ echo "TODO test sentence 1" | apertium -d . fra-frp
TODO test translated sentence 1

$ echo "TODO test sentence 2" | apertium -d . frp-fra
TODO test translated sentence 2
```

After installing somewhere in `$PATH`, you should be able to do e.g.

```console
$ echo "TODO test sentence 1" | apertium fra-frp
TODO test translated sentence 1
```

Files and data
-------------------------------------------------------------------------------

* [`apertium-fra-frp.fra-frp.dix`](apertium-fra-frp.fra-frp.dix) - Bilingual dictionary
* [`apertium-fra-frp.fra-frp.t1x`](apertium-fra-frp.fra-frp.t1x) - Chunking rules for translating into Arpitan
* [`apertium-fra-frp.frp-fra.t1x`](apertium-fra-frp.frp-fra.t1x) - Chunking rules for translating into French
* [`apertium-fra-frp.fra-frp.t2x`](apertium-fra-frp.fra-frp.t2x) - Interchunk rules for translating into Arpitan
* [`apertium-fra-frp.frp-fra.t2x`](apertium-fra-frp.frp-fra.t2x) - Interchunk rules for translating into French
* [`apertium-fra-frp.fra-frp.t3x`](apertium-fra-frp.fra-frp.t3x) - Postchunk rules for translating into Arpitan
* [`apertium-fra-frp.frp-fra.t3x`](apertium-fra-frp.frp-fra.t3x) - Postchunk rules for translating into French
* [`apertium-fra-frp.fra-frp.metalrx`](apertium-fra-frp.fra-frp.metalrx) - Lexical selection rules for translating into Arpitan
* [`apertium-fra-frp.frp-fra.metalrx`](apertium-fra-frp.frp-fra.metalrx) - Lexical selection rules for translating into French
* [`modes.xml`](modes.xml) - Translation modes

For more information
-------------------------------------------------------------------------------

* http://wiki.apertium.org/wiki/Installation
* http://wiki.apertium.org/wiki/apertium-fra-frp
* http://wiki.apertium.org/wiki/Using_an_lttoolbox_dictionary

Help and support
-------------------------------------------------------------------------------

If you need help using this language pair or data, you can contact:

* Mailing list: apertium-stuff@lists.sourceforge.net
* IRC: `#apertium` on irc.freenode.net (irc://irc.freenode.net/#apertium)

See also the file [`AUTHORS`](AUTHORS), included in this distribution.
