# F.2 What do "anarcho"-capitalists mean by freedom?

For "anarcho"-capitalists, the concept of freedom is limited to the idea of
_"freedom from."_ For them, freedom means simply freedom from the _"initiation
of force,"_ or the _"non-aggression against anyone's person and property."_
[Murray Rothbard, **For a New Liberty**, p. 23] The notion that real freedom
must combine both freedom _"to"_ **and** freedom _"from"_ is missing in their
ideology, as is the social context of the so-called freedom they defend.

Before continuing, it is useful to quote Alan Haworth when he notes that
_"[i]n fact, it is surprising how **little** close attention the concept of
freedom receives from libertarian writers. Once again **Anarchy, State, and
Utopia** is a case in point. The word 'freedom' doesn't even appear in the
index. The word 'liberty' appears, but only to refer the reader to the 'Wilt
Chamberlain' passage. In a supposedly 'libertarian' work, this is more than
surprising. It is truly remarkable."_ [**Anti-Libertarianism**, p. 95] Why
this is the case can be seen from how the right-"libertarian" defines freedom.

In right-"libertarian" and "anarcho"-capitalist ideology, freedom is
considered to be a product of property. As Murray Rothbard puts it, _"the
libertarian defines the concept of 'freedom' or 'liberty'. . .[as a] condition
in which a person's ownership rights in his body and his legitimate material
property rights are not invaded, are not aggressed against. . . . Freedom and
unrestricted property rights go hand in hand."_ [**Op. Cit.**, p.41]

This definition has some problems, however. In such a society, one cannot
(legitimately) do anything with or on another's property if the owner
prohibits it. This means that an individual's only **guaranteed** freedom is
determined by the amount of property that he or she owns. This has the
consequence that someone with no property has no guaranteed freedom at all
(beyond, of course, the freedom not to be murdered or otherwise harmed by the
deliberate acts of others). In other words, a distribution of property is a
distribution of freedom, as the right-"libertarians" themselves define it. It
strikes anarchists as strange that an ideology that claims to be committed to
promoting freedom entails the conclusion that some people should be more free
than others. Yet this is the logical implication of their view, which raises a
serious doubt as to whether "anarcho"-capitalists are actually interested in
freedom at all.

Looking at Rothbard's definition of "liberty" quoted above, we can see that
freedom is actually no longer considered to be a fundamental, independent
concept. Instead, freedom is a derivative of something more fundamental,
namely the _"legitimate rights"_ of an individual, which are identified as
property rights. In other words, given that "anarcho"-capitalists and
right-"libertarians" in general consider the right to property as "absolute,"
it follows that freedom and property become one and the same. This suggests an
alternative name for the right Libertarian, namely **_"Propertarian."_** And,
needless to say, if we do not accept the right-libertarians' view of what
constitutes "legitimate rights," then their claim to be defenders of liberty
is weak.

Another important implication of this "liberty as property" concept is that it
produces a strangely alienated concept of freedom. Liberty, as we noted, is no
longer considered absolute, but a derivative of property -- which has the
important consequence that you can "sell" your liberty and still be considered
free by the ideology. This concept of liberty is usually termed "self-
ownership." But, to state the obvious, I do not "own" myself, as if were an
object somehow separable from my subjectivity -- I **am** myself (see [section
B.4.2](secB4.md#secb42)). However, the concept of "self-ownership" is handy
for justifying various forms of domination and oppression -- for by agreeing
(usually under the force of circumstances, we must note) to certain contracts,
an individual can "sell" (or rent out) themselves to others (for example, when
workers sell their labour power to capitalists on the "free market"). In
effect, "self-ownership" becomes the means of justifying treating people as
objects -- ironically, the very thing the concept was created to stop! As
anarchist L. Susan Brown notes, _"[a]t the moment an individual 'sells' labour
power to another, he/she loses self-determination and instead is treated as a
subjectless instrument for the fulfilment of another's will."_ [**The Politics
of Individualism**, p. 4]

Given that workers are paid to obey, you really have to wonder which planet
Murray Rothbard was on when he argued that a person's _"labour service is
alienable, but his **will** is not"_ and that he _"cannot alienate his
**will**, more particularly his control over his own mind and body."_ He
contrasts private property and self-ownership by arguing that _"[a]ll physical
property owned by a person is alienable . . . I can give away or sell to
another person my shoes, my house, my car, my money, etc. But there are
certain vital things which, in natural fact and in the nature of man, are
**in**alienable . . . [his] will and control over his own person are
inalienable."_ [**The Ethics of Liberty**, p. 40, p. 135 and pp. 134-5] Yet
_"labour services"_ are unlike the private possessions Rothbard lists as being
alienable. As we argued in [section B.1](secB1.md) a person's _"labour
services"_ and _"will"_ cannot be divided -- if you sell your labour services,
you also have to give control of your body and mind to another person. If a
worker does not obey the commands of her employer, she is fired. That Rothbard
denied this indicates a total lack of common-sense. Perhaps Rothbard would
have argued that as the worker can quit at any time she does not really
alienate their will (this seems to be his case against slave contracts -- see
[section F.2.2](secF2.md#secf22)). But this ignores the fact that between
the signing and breaking of the contract and during work hours (and perhaps
outside work hours, if the boss has mandatory drug testing or will fire
workers who attend union or anarchist meetings or those who have an
"unnatural" sexuality and so on) the worker **does** alienate his will and
body. In the words of Rudolf Rocker, _"under the realities of the capitalist
economic form . . . there can . . . be no talk of a 'right over one's own
person,' for that ends when one is compelled to submit to the economic
dictation of another if he does not want to starve."_ [**Anarcho-
Syndicalism**, p. 10]

Ironically, the rights of property (which are said to flow from an
individual's self-ownership of themselves) becomes the means, under
capitalism, by which self-ownership of non-property owners is denied. The
foundational right (self-ownership) becomes denied by the derivative right
(ownership of things). _"To treat others and oneself as property,"_ argues L.
Susan Brown, _"objectifies the human individual, denies the unity of subject
and object and is a negation of individual will . . . [and] destroys the very
freedom one sought in the first place. The liberal belief in property, both
real and in the person, leads not to freedom but to relationships of
domination and subordination."_ [**Op. Cit.**, p. 3] Under capitalism, a lack
of property can be just as oppressive as a lack of legal rights because of the
relationships of domination and subjection this situation creates. That people
"consent" to this hierarchy misses the point. As Alexander Berkman put it:

> _ "The law says your employer does not steal anything from you, because it
is done with your consent. You have agreed to work for your boss for certain
pay, he to have all that you produce . . .  
>  _

>

> _"But did you really consent? _

>

> _"When the highway man holds his gun to your head, you turn your valuables
over to him. You 'consent' all right, but you do so because you cannot help
yourself, because you are **compelled** by his gun. _

>

> _"Are you not **compelled** to work for an employer? Your need compels you
just as the highwayman's gun. You must live . . . You can't work for yourself
. . . The factories, machinery, and tools belong to the employing class, so
you **must** hire yourself out to that class in order to work and live.
Whatever you work at, whoever your employer may be, it always comes to the
same: you must work **for him**. You can't help yourself. You are
**compelled**."_ [**What is Anarchism?**, p. 11]

Due to this class monopoly over the means of life, workers (usually) are at a
disadvantage in terms of bargaining power -- there are more workers than jobs
(see [ section C.9](secC9.md)). Within capitalism there is no equality
between owners and the dispossessed, and so property is a source of **power.**
To claim that this power should be "left alone" or is "fair" is _"to the
anarchists. . . preposterous. Once a State has been established, and most of
the country's capital privatised, the threat of physical force is no longer
necessary to coerce workers into accepting jobs, even with low pay and poor
conditions. To use [right-"libertarian"] Ayn Rand's term, 'initial force' has
**already taken place,** by those who now have capital against those who do
not. . . . In other words, if a thief died and willed his 'ill-gotten gain' to
his children, would the children have a right to the stolen property? Not
legally. So if 'property is theft,' to borrow Proudhon's quip, and the fruit
of exploited labour is simply legal theft, then the only factor giving the
children of a deceased capitalist a right to inherit the 'booty' is the law,
the State. As Bakunin wrote, 'Ghosts should not rule and oppress this world,
which belongs only to the living.'"_ [Jeff Draughn, **Between Anarchism and
Libertarianism**]

Or, in other words, right-Libertarianism fails to _"meet the charge that
normal operations of the market systematically places an entire class of
persons (wage earners) in circumstances that compel them to accept the terms
and conditions of labour dictated by those who offer work. While it is true
that individuals are formally free to seek better jobs or withhold their
labour in the hope of receiving higher wages, in the end their position in the
market works against them; they cannot live if they do not find employment.
When circumstances regularly bestow a relative disadvantage on one class of
persons in their dealings with another class, members of the advantaged class
have little need of coercive measures to get what they want."_ [Stephen L.
Newman, **Liberalism at Wit's End**, p. 130] Eliminating taxation does not end
oppression, in other words. As Tolstoy put it:

> _ "in Russia serfdom was only abolished when all the land had been
appropriated. When land was granted to the peasants, it was burdened with
payments which took the place of the land slavery. In Europe, taxes that kept
the people in bondage began to be abolished only when the people had lost
their land, were unaccustomed to agricultural work, and . . . quite dependent
on the capitalists . . . [They] abolish the taxes that fall on the workers . .
. only because the majority of the people are already in the hands of the
capitalists. One form of slavery is not abolished until another has already
replaced it."_ [**The Slavery of Our Times**, p. 32]

So Rothbard's argument (as well as being contradictory) misses the point (and
the reality of capitalism). Yes, **if** we define freedom as _"the absence of
coercion"_ then the idea that wage labour does not restrict liberty is
unavoidable, but such a definition is useless. This is because it hides
structures of power and relations of domination and subordination. As Carole
Pateman argues, _"the contract in which the worker allegedly sells his labour
power is a contract in which, since he cannot be separated from his
capacities, he sells command over the use of his body and himself . . . To
sell command over the use of oneself for a specified period . . . is to be an
unfree labourer. The characteristics of this condition are captured in the
term **wage slave**."_ [**The Sexual Contract**, p. 151]

In other words, contracts about property in the person inevitably create
subordination. "Anarcho"-capitalism defines this source of unfreedom away, but
it still exists and has a major impact on people's liberty. For anarchists
freedom is better described as "self-government" or "self-management" -- to be
able to govern ones own actions (if alone) or to participate in the
determination of join activity (if part of a group). Freedom, to put it
another way, is not an abstract legal concept, but the vital concrete
possibility for every human being to bring to full development all their
powers, capacities, and talents which nature has endowed them. A key aspect of
this is to govern one own actions when within associations (self-management).
If we look at freedom this way, we see that coercion is condemned but so is
hierarchy (and so is capitalism for during working hours people are not free
to make their own plans and have a say in what affects them. They are order
takers, **not** free individuals).

It is because anarchists have recognised the authoritarian nature of
capitalist firms that they have opposed wage labour and capitalist property
rights along with the state. They have desired to replace institutions
structured by subordination with institutions constituted by free
relationships (based, in other words, on self-management) in **all** areas of
life, including economic organisations. Hence Proudhon's argument that the
_"workmen's associations . . . are full of hope both as a protest against the
wage system, and as an affirmation of **reciprocity**"_ and that their
importance lies _"in their denial of the rule of capitalists, money lenders
and governments."_ [**The General Idea of the Revolution**, pp. 98-99]

Unlike anarchists, the "anarcho"-capitalist account of freedom allows an
individual's freedom to be rented out to another while maintaining that the
person is still free. It may seem strange that an ideology proclaiming its
support for liberty sees nothing wrong with the alienation and denial of
liberty but, in actual fact, it is unsurprising. After all, contract theory is
a _"theoretical strategy that justifies subjection by presenting it as
freedom"_ and has _"turned a subversive proposition [that we are born free and
equal] into a defence of civil subjection."_ Little wonder, then, that
contract _"creates a relation of subordination"_ and not of freedom [Carole
Pateman, **Op. Cit.**, p. 39 and p. 59] Little wonder, then, that Colin Ward
argued that, as an anarchist, he is _"by definition, a socialist"_ and that
_"[w]orkers' control of industrial production"_ is _"the only approach
compatible with anarchism."_ [**Talking Anarchy**, p. 25 and p. 26]

Ultimately, any attempt to build an ethical framework starting from the
abstract individual (as Rothbard does with his _"legitimate rights"_ method)
will result in domination and oppression between people, **not** freedom.
Indeed, Rothbard provides an example of the dangers of idealist philosophy
that Bakunin warned about when he argued that while _"[m]aterialism denies
free will and ends in the establishment of liberty; idealism, in the name of
human dignity, proclaims free will, and on the ruins of every liberty founds
authority."_ [**God and the State**, p. 48] That this is the case with
"anarcho"-capitalism can be seen from Rothbard's wholehearted support for wage
labour, landlordism and the rules imposed by property owners on those who use,
but do not own, their property. Rothbard, basing himself on abstract
individualism, cannot help but justify authority over liberty. This,
undoubtedly, flows from the right-liberal and conservative roots of his
ideology. Individualist anarchist Shawn Wilbar once defined Wikipedia as _"the
most successful modern experiment in promoting obedience to authority as
freedom."_ However, Wikipedia pales into insignificance compared to the
success of liberalism (in its many forms) in doing precisely that. Whether
politically or economically, liberalism has always rushed to justify and
rationalise the individual subjecting themselves to some form of hierarchy.
That "anarcho"-capitalism does this under the name "anarchism" is deeply
insulting to anarchists.

Overall, we can see that the logic of the right-"libertarian" definition of
"freedom" ends up negating itself because it results in the creation and
encouragement of **authority,** which is an **opposite** of freedom. For
example, as Ayn Rand pointed out, _"man has to sustain his life by his own
effort, the man who has no right to the product of his effort has no means to
sustain his life. The man who produces while others dispose of his product, is
a slave."_ [**The Ayn Rand Lexicon: Objectivism from A to Z**, pp. 388-9] But,
as was shown in [section C.2](secC2.md), capitalism is based on, as Proudhon
put it, workers working _"for an entrepreneur who pays them and keeps their
products,"_ and so is a form of **theft.** Thus, by "libertarian" capitalism's
**own** logic, capitalism is based not on freedom, but on (wage) slavery; for
interest, profit and rent are derived from a worker's **unpaid** labour, i.e.
_"others dispose of his [sic] product."_

Thus it is debatable that a right-"libertarian" or "anarcho" capitalist
society would have less unfreedom or authoritarianism in it than "actually
existing" capitalism. In contrast to anarchism, "anarcho"-capitalism, with its
narrow definitions, restricts freedom to only a few areas of social life and
ignores domination and authority beyond those aspects. As Peter Marshall
points out, their _"definition of freedom is entirely negative. It calls for
the absence of coercion but cannot guarantee the positive freedom of
individual autonomy and independence."_ [**Demanding the Impossible**, p. 564]
By confining freedom to such a narrow range of human action,
"anarcho"-capitalism is clearly **not** a form of anarchism. Real anarchists
support freedom in every aspect of an individual's life.

In short, as French anarchist Elisee Reclus put it there is _"an abyss between
two kinds of society,"_ one of which is _"constituted freely by men of good
will, based on a consideration of their common interests"_ and another which
_"accepts the existence of either temporary or permanent masters to whom [its
members] owe obedience."_ [quoted by Clark and Martin, **Anarchy, Geography,
Modernity**, p. 62] In other words, when choosing between anarchism and
capitalism, "anarcho"-capitalists pick the latter and call it the former.

## F.2.1 How does private property affect freedom?

The right-"libertarian" either does not acknowledge or dismisses as irrelevant
the fact that the (absolute) right of private property may lead to extensive
control by property owners over those who use, but do not own, property (such
as workers and tenants). Thus a free-market capitalist system leads to a very
selective and class-based protection of "rights" and "freedoms." For example,
under capitalism, the "freedom" of employers inevitably conflicts with the
"freedom" of employees. When stockholders or their managers exercise their
"freedom of enterprise" to decide how their company will operate, they violate
their employee's right to decide how their labouring capacities will be
utilised and so under capitalism the "property rights" of employers will
conflict with and restrict the "human right" of employees to manage
themselves. Capitalism allows the right of self-management only to the few,
not to all. Or, alternatively, capitalism does not recognise certain human
rights as **universal** which anarchism does.

This can be seen from Austrian Economist W. Duncan Reekie's defence of wage
labour. While referring to _"intra-firm labour markets"_ as _"hierarchies"_,
Reekie (in his best _**ex cathedra**_ tone) states that _"[t]here is nothing
authoritarian, dictatorial or exploitative in the relationship. Employees
order employers to pay them amounts specified in the hiring contract just as
much as employers order employees to abide by the terms of the contract."_
[**Markets, Entrepreneurs and Liberty**, p. 136 and p. 137]. Given that _"the
terms of contract"_ involve the worker agreeing to obey the employers orders
and that they will be fired if they do not, its pretty clear that the ordering
that goes on in the _"intra-firm labour market"_ is decidedly **one way**.
Bosses have the power, workers are paid to obey. And this begs the question:
**if** the employment contract creates a free worker, why must she abandon her
liberty during work hours?

Reekie actually recognises this lack of freedom in a "round about" way when he
notes that _"employees in a firm at any level in the hierarchy can exercise an
entrepreneurial role. The area within which that role can be carried out
increases the more authority the employee has."_ [**Op. Cit.**, p. 142] Which
means workers **are** subject to control from above which restricts the
activities they are allowed to do and so they are **not** free to act, make
decisions, participate in the plans of the organisation, to create the future
and so forth within working hours. And it is strange that while recognising
the firm as a hierarchy, Reekie tries to deny that it is authoritarian or
dictatorial -- as if you could have a hierarchy without authoritarian
structures or an unelected person in authority who is not a dictator. His
confusion is shared by Austrian guru Ludwig von Mises, who asserted that the
_"entrepreneur and capitalist are not irresponsible autocrats"_ because they
are _"unconditionally subject to the sovereignty of the consumer"_ while, **on
the next page**, admitting there was a _"managerial hierarchy"_ which contains
_"the average subordinate employee."_ [**Human Action**, p. 809 and p. 810] It
does not enter his mind that the capitalist may be subject to some consumer
control while being an autocrat to their subordinated employees. Again, we
find the right-"libertarian" acknowledging that the capitalist managerial
structure is a hierarchy and workers are subordinated while denying it is
autocratic to the workers! Thus we have "free" workers within a relationship
distinctly **lacking** freedom -- a strange paradox. Indeed, if your personal
life were as closely monitored and regulated as the work life of millions of
people across the world, you would rightly consider it the worse form of
oppression and tyranny.

Somewhat ironically, right-wing liberal and "free market" economist Milton
Friedman contrasted _"central planning involving the use of coercion -- the
technique of the army or the modern totalitarian state"_ with _"voluntary co-
operation between individuals -- the technique of the marketplace"_ as two
distinct ways of co-ordinating the economic activity of large groups
(_"millions"_) of people. [**Capitalism and Freedom**, p. 13] However, this
misses the key issue of the internal nature of the company. As
right-"libertarians" themselves note, the internal structure of a capitalist
company is hierarchical. Indeed, the capitalist company **is** a form of
central planning and so shares the same "technique" as the army. As Peter
Drucker noted in his history of General Motors, _"[t]here is a remarkably
close parallel between General Motors' scheme of organisation and those of the
two institutions most renowned for administrative efficiency: that of the
Catholic Church and that of the modern army."_ [quoted by David Engler,
**Apostles of Greed**, p. 66] Thus capitalism is marked by a series of
totalitarian organisations. Dictatorship does not change much -- nor does it
become less fascistic -- when discussing economic structures rather than
political ones. To state the obvious, _"the employment contract (like the
marriage contract) is not an exchange; both contracts create social relations
that endure over time - social relations of subordination."_ [Carole Pateman,
**The Sexual Contract**, p. 148]

Perhaps Reekie (like most right-"libertarians") will maintain that workers
voluntarily agree ("consent") to be subject to the bosses dictatorship (he
writes that _"each will only enter into the contractual agreement known as a
firm if each believes he will be better off thereby. The firm is simply
another example of mutually beneficial exchange."_ [**Op. Cit.**, p. 137]).
However, this does not stop the relationship being authoritarian or
dictatorial (and so exploitative as it is **highly** unlikely that those at
the top will not abuse their power). Representing employment relations as
voluntary agreement simply mystifies the existence and exercise of power
within the organisation so created.

As we argue further in the [section F.3](secF3.md), in a capitalist society
workers have the option of finding a job or facing abject poverty and/or
starvation. Little wonder, then, that people "voluntarily" sell their labour
and "consent" to authoritarian structures! They have little option to do
otherwise. So, **within** the labour market workers **can** and **do** seek
out the best working conditions possible, but that does not mean that the
final contract agreed is "freely" accepted and not due to the force of
circumstances, that both parties have equal bargaining power when drawing up
the contract or that the freedom of both parties is ensured.

Which means to argue (as right-"libertarians" do) that freedom cannot be
restricted by wage labour because people enter into relationships they
consider will lead to improvements over their initial situation totally misses
the point. As the initial situation is not considered relevant, their argument
fails. After all, agreeing to work in a sweatshop 14 hours a day **is** an
improvement over starving to death -- but it does not mean that those who so
agree are free when working there or actually **want** to be there. They are
not and it is the circumstances, created and enforced by the law (i.e., the
state), that have ensured that they "consent" to such a regime (given the
chance, they would desire to **change** that regime but cannot as this would
violate their bosses property rights and they would be repressed for trying).

So the right-wing "libertarian" right is interested only in a narrow concept
of freedom (rather than in freedom or liberty as such). This can be seen in
the argument of Ayn Rand that _"**Freedom**, in a political context, means
freedom from government coercion. It does **not** mean freedom from the
landlord, or freedom from the employer, or freedom from the laws of nature
which do not provide men with automatic prosperity. It means freedom from the
coercive power of the state -- and nothing else!"_ [**Capitalism: The Unknown
Ideal**, p. 192] By arguing in this way, right-"libertarians" ignore the vast
number of authoritarian social relationships that exist in capitalist society
and, as Rand does here, imply that these social relationships are like _"the
laws of nature."_ However, if one looks at the world without prejudice but
with an eye to maximising freedom, the major coercive institutions are the
state **and** capitalist social relationships (and the latter relies on the
former). It should also be noted that, unlike gravity, the power of the
landlord and boss depends on the use of force -- gravity does not need
policemen to make things fall!

The right "libertarian," then, far from being a defender of freedom, is in
fact a keen defender of certain forms of authority. As Kropotkin argued
against a forerunner of right-"libertarianism":

> _ "The modern Individualism initiated by Herbert Spencer is, like the
critical theory of Proudhon, a powerful indictment against the dangers and
wrongs of government, but its practical solution of the social problem is
miserable -- so miserable as to lead us to inquire if the talk of 'No force'
be merely an excuse for supporting landlord and capitalist domination."_
[**Act For Yourselves**, p. 98]

To defend the "freedom" of property owners is to defend authority and
privilege -- in other words, statism. So, in considering the concept of
liberty as "freedom from," it is clear that by defending private property (as
opposed to possession) the "anarcho"-capitalist is defending the power and
authority of property owners to govern those who use "their" property. And
also, we must note, defending all the petty tyrannies that make the work lives
of so many people frustrating, stressful and unrewarding.

Anarchism, by definition, is in favour of organisations and social
relationships which are non-hierarchical and non-authoritarian. Otherwise,
some people are more free than others. Failing to attack hierarchy leads to
massive contradiction. For example, since the British Army is a volunteer one,
it is an "anarchist" organisation! Ironically, it can also allow a state to
appear "libertarian" as that, too, can be considered voluntary arrangement as
long as it allows its subjects to emigrate freely. So equating freedom with
(capitalist) property rights does not protect freedom, in fact it actively
denies it. This lack of freedom is only inevitable as long as we accept
capitalist private property rights. If we reject them, we can try and create a
world based on freedom in all aspects of life, rather than just in a few.

## F.2.2 Do "libertarian"-capitalists support slavery?

Yes. It may come as a surprise to many people, but right-"Libertarianism" is
one of the few political theories that justifies slavery. For example, Robert
Nozick asks whether _"a free system would allow [the individual] to sell
himself into slavery"_ and he answers _"I believe that it would."_ [**Anarchy,
State and Utopia**, p. 371] While some right-"libertarians" do not agree with
Nozick, there is no logical basis in their ideology for such disagreement.

This can be seen from "anarcho"-capitalist Walter Block, who, like Nozick,
supports voluntary slavery. As he puts it, _"if I own something, I can sell it
(and should be allowed by law to do so). If I can't sell, then, and to that
extent, I really don't own it."_ Thus agreeing to sell yourself for a lifetime
_"is a bona fide contract"_ which, if _"abrogated, theft occurs."_ He
critiques those other right-wing "libertarians" (like Murray Rothbard) who
oppose voluntary slavery as being inconsistent to their principles. Block, in
his words, seeks to make _"a tiny adjustment"_ which _"strengthens
libertarianism by making it more internally consistent."_ He argues that his
position shows _"that contract, predicated on private property [can] reach to
the furthest realms of human interaction, even to voluntary slave contracts."_
[_"Towards a Libertarian Theory of Inalienability: A Critique of Rothbard,
Barnett, Smith, Kinsella, Gordon, and Epstein,"_ pp. 39-85, **Journal of
Libertarian Studies**, vol. 17, no. 2, p. 44, p. 48, p. 82 and p. 46]

So the logic is simple, you cannot really own something unless you can sell
it. Self-ownership is one of the cornerstones of laissez-faire capitalist
ideology. Therefore, since you own yourself you can sell yourself.

This defence of slavery should not come as a surprise to any one familiar with
classical liberalism. An elitist ideology, its main rationale is to defend the
liberty and power of property owners and justify unfree social relationships
(such as government and wage labour) in terms of "consent." Nozick and Block
just takes it to its logical conclusion. This is because his position is not
new but, as with so many other right-"libertarian" ones, can be found in John
Locke's work. The key difference is that Locke refused the term _"slavery"_
and favoured _"drudgery"_ as, for him, slavery mean a relationship _"between a
lawful conqueror and a captive"_ where the former has the power of life and
death over the latter. Once a _"compact"_ is agreed between them, _"an
agreement for a limited power on the one side, and obedience on the other . .
. slavery ceases."_ As long as the master could not kill the slave, then it
was _"drudgery."_ Like Nozick, he acknowledges that _"men did sell themselves;
but, it is plain, this was only to drudgery, not to slavery: for, it is
evident, the person sold was not under an absolute, arbitrary, despotical
power: for the master could not have power to kill him, at any time, whom, at
a certain time, he was obliged to let go free out of his service."_ [Locke,
**Second Treatise of Government**, Section 24] In other words, voluntary
slavery was fine but just call it something else.

Not that Locke was bothered by **involuntary** slavery. He was heavily
involved in the slave trade. He owned shares in the **"Royal Africa Company"**
which carried on the slave trade for England, making a profit when he sold
them. He also held a significant share in another slave company, the **"Bahama
Adventurers."** In the _"Second Treatise"_, Locke justified slavery in terms
of _"Captives taken in a just war,"_ a war waged against aggressors. [Section
85] That, of course, had nothing to do with the **actual** slavery Locke
profited from (slave raids were common, for example). Nor did his "liberal"
principles stop him suggesting a constitution that would ensure that _"every
freeman of Carolina shall have absolute power and authority over his Negro
slaves."_ The constitution itself was typically autocratic and hierarchical,
designed explicitly to _"avoid erecting a numerous democracy."_ [**The Works
of John Locke**, vol. X, p. 196]

So the notion of contractual slavery has a long history within right-wing
liberalism, although most refuse to call it by that name. It is of course
simply embarrassment that stops many right-"libertarians" calling a spade a
spade. They incorrectly assume that slavery has to be involuntary. In fact,
historically, voluntary slave contracts have been common (David Ellerman's
**Property and Contract in Economics** has an excellent overview). Any new
form of voluntary slavery would be a "civilised" form of slavery and could
occur when an individual would "agree" to sell their lifetime's labour to
another (as when a starving worker would "agree" to become a slave in return
for food). In addition, the contract would be able to be broken under certain
conditions (perhaps in return for breaking the contract, the former slave
would have pay damages to his or her master for the labour their master would
lose -- a sizeable amount no doubt and such a payment could result in debt
slavery, which is the most common form of "civilised" slavery. Such damages
may be agreed in the contract as a "performance bond" or "conditional
exchange."

In summary, right-"libertarians" are talking about "civilised" slavery (or, in
other words, civil slavery) and not forced slavery. While some may have
reservations about calling it slavery, they agree with the basic concept that
since people own themselves they can sell themselves, that is sell their
labour for a lifetime rather than piecemeal.

We must stress that this is no academic debate. "Voluntary" slavery has been a
problem in many societies and still exists in many countries today
(particularly third world ones where bonded labour -- i.e. where debt is used
to enslave people -- is the most common form). With the rise of sweat shops
and child labour in many "developed" countries such as the USA, "voluntary"
slavery (perhaps via debt and bonded labour) may become common in all parts of
the world -- an ironic (if not surprising) result of "freeing" the market and
being indifferent to the actual freedom of those within it.

Some right-"libertarians" are obviously uneasy with the logical conclusion of
their definition of freedom. Murray Rothbard, for example, stressed the
_"unenforceability, in libertarian theory, of voluntary slave contracts."_ Of
course, **other** "libertarian" theorists claim the exact opposite, so
_"libertarian theory"_ makes no such claim, but never mind! Essentially, his
objection revolves around the assertion that a person _"cannot, in nature,
sell himself into slavery and have this sale enforced -- for this would mean
that his future will over his own body was being surrendered in advance"_ and
that if a _"labourer remains totally subservient to his master's will
voluntarily, he is not yet a slave since his submission is voluntary."_
However, as we noted in [section F.2](secF2.md), Rothbard emphasis on
quitting fails to recognise the actual denial of will and control over ones
own body that is explicit in wage labour. It is this failure that pro-slave
contract "libertarians" stress -- they consider the slave contract as an
extended wage contract. Moreover, a modern slave contract would likely take
the form of a _"performance bond,"_ on which Rothbard laments about its
_"unfortunate suppression"_ by the state. In such a system, the slave could
agree to perform X years labour or pay their master substantial damages if
they fail to do so. It is the threat of damages that enforces the contract and
such a "contract" Rothbard does agree is enforceable. Another means of
creating slave contracts would be _"conditional exchange"_ which Rothbard also
supports. As for debt bondage, that too, seems acceptable. He surreally notes
that paying damages and debts in such contracts is fine as _"money, of course,
**is** alienable"_ and so forgets that it needs to be earned by labour which,
he asserts, is **not** alienable! [**The Ethics of Liberty,** pp. 134-135, p.
40, pp. 136-9, p. 141 and p. 138]

It should be noted that the slavery contract cannot be null and void because
it is unenforceable, as Rothbard suggests. This is because the doctrine of
specific performance applies to all contracts, not just to labour contracts.
This is because **all** contracts specify some future performance. In the case
of the lifetime labour contract, then it can be broken as long as the slave
pays any appropriate damages. As Rothbard puts it elsewhere, _"if A has agreed
to work for life for B in exchange for 10,000 grams of gold, he will have to
return the proportionate amount of property if he terminates the arrangement
and ceases to work."_ [**Man, Economy, and State**, vol. I , p. 441] This is
understandable, as the law generally allows material damages for breached
contracts, as does Rothbard in his support for the _"performance bond"_ and
_"conditional exchange."_ Needless to say, having to pay such damages (either
as a lump sum or over a period of time) could turn the worker into the most
common type of modern slave, the debt-slave.

And it is interesting to note that even Murray Rothbard is not against the
selling of humans. He argued that children are the property of their parents
who can (bar actually murdering them by violence) do whatever they please with
them, even sell them on a _"flourishing free child market."_ [**The Ethics of
Liberty**, p. 102] Combined with a whole hearted support for child labour
(after all, the child can leave its parents if it objects to working for them)
such a "free child market" could easily become a "child slave market" -- with
entrepreneurs making a healthy profit selling infants and children or their
labour to capitalists (as did occur in 19th century Britain). Unsurprisingly,
Rothbard ignores the possible nasty aspects of such a market in human flesh
(such as children being sold to work in factories, homes and brothels). But
this is besides the point.

Of course, this theoretical justification for slavery at the heart of an
ideology calling itself "libertarianism" is hard for many right-"libertarians"
to accept and so they argue that such contracts would be very hard to enforce.
This attempt to get out of the contradiction fails simply because it ignores
the nature of the capitalist market. If there is a demand for slave contracts
to be enforced, then companies will develop to provide that "service" (and it
would be interesting to see how two "protection" firms, one defending slave
contracts and another not, could compromise and reach a peaceful agreement
over whether slave contracts were valid). Thus we could see a so-called "free"
society producing companies whose specific purpose was to hunt down escaped
slaves (i.e. individuals in slave contracts who have not paid damages to their
owners for freedom). Of course, perhaps Rothbard would claim that such slave
contracts would be "outlawed" under his _"general libertarian law code"_ but
this is a denial of market "freedom". If slave contracts **are** "banned" then
surely this is paternalism, stopping individuals from contracting out their
"labour services" to whom and however long they "desire". You cannot have it
both ways.

So, ironically, an ideology proclaiming itself to support "liberty" ends up
justifying and defending slavery. Indeed, for the right-"libertarian" the
slave contract is an exemplification, not the denial, of the individual's
liberty! How is this possible? How can slavery be supported as an expression
of liberty? Simple, right-"libertarian" support for slavery is a symptom of a
**deeper** authoritarianism, namely their uncritical acceptance of contract
theory. The central claim of contract theory is that contract is the means to
secure and enhance individual freedom. Slavery is the antithesis to freedom
and so, in theory, contract and slavery must be mutually exclusive. However,
as indicated above, some contract theorists (past and present) have included
slave contracts among legitimate contracts. This suggests that contract theory
cannot provide the theoretical support needed to secure and enhance individual
freedom.

As Carole Pateman argues, _"contract theory is primarily about a way of
creating social relations constituted by subordination, not about exchange."_
Rather than undermining subordination, contract theorists justify modern
subjection -- _"contract doctrine has proclaimed that subjection to a master
-- a boss, a husband -- is freedom."_ [**The Sexual Contract**, p. 40 and p.
146] The question central to contract theory (and so right-Libertarianism) is
not "are people free" (as one would expect) but "are people free to
subordinate themselves in any manner they please." A radically different
question and one only fitting to someone who does not know what liberty means.

Anarchists argue that not all contracts are legitimate and no free individual
can make a contract that denies his or her own freedom. If an individual is
able to express themselves by making free agreements then those free
agreements must also be based upon freedom internally as well. Any agreement
that creates domination or hierarchy negates the assumptions underlying the
agreement and makes itself null and void. In other words, voluntary government
is still government and a defining characteristic of an anarchy must be,
surely, "no government" and "no rulers."

This is most easily seen in the extreme case of the slave contract. John
Stuart Mill stated that such a contract would be "null and void." He argued
that an individual may voluntarily choose to enter such a contract but in so
doing _"he abdicates his liberty; he foregoes any future use of it beyond that
single act. He therefore defeats, in his own case, the very purpose which is
the justification of allowing him to dispose of himself. . .The principle of
freedom cannot require that he should be free not to be free. It is not
freedom, to be allowed to alienate his freedom."_ He adds that _"these
reasons, the force of which is so conspicuous in this particular case, are
evidently of far wider application."_ [quoted by Pateman, **Op. Cit.**, pp.
171-2]

And it is such an application that defenders of capitalism fear (Mill did in
fact apply these reasons wider and unsurprisingly became a supporter of a
market syndicalist form of socialism). If we reject slave contracts as
illegitimate then, logically, we must also reject **all** contracts that
express qualities similar to slavery (i.e. deny freedom) including wage
slavery. Given that, as David Ellerman points out, _"the voluntary slave . . .
and the employee cannot in fact take their will out of their intentional
actions so that they could be 'employed' by the master or employer"_ we are
left with _"the rather implausible assertion that a person can vacate his or
her will for eight or so hours a day for weeks, months, or years on end but
cannot do so for a working lifetime."_ [**Property and Contract in
Economics**, p. 58] This is Rothbard's position.

The implications of supporting voluntary slavery is quite devastating for all
forms of right-wing "libertarianism." This was proven by Ellerman when he
wrote an extremely robust defence of it under the pseudonym "J. Philmore"
called **The Libertarian Case for Slavery** (first published in **The
Philosophical Forum**, xiv, 1982). This classic rebuttal takes the form of
"proof by contradiction" (or **reductio ad absurdum**) whereby he takes the
arguments of right-libertarianism to their logical end and shows how they
reach the memorably conclusion that the _"time has come for liberal economic
and political thinkers to stop dodging this issue and to critically re-examine
their shared prejudices about certain voluntary social institutions . . . this
critical process will inexorably drive liberalism to its only logical
conclusion: libertarianism that finally lays the true moral foundation for
economic and political slavery."_ Ellerman shows how, from a
right-"libertarian" perspective there is a _"fundamental contradiction"_ in a
modern liberal society for the state to prohibit slave contracts. He notes
that there _"seems to be a basic shared prejudice of liberalism that slavery
is inherently involuntary, so the issue of genuinely voluntary slavery has
received little scrutiny. The perfectly valid liberal argument that
involuntary slavery is inherently unjust is thus taken to include voluntary
slavery (in which case, the argument, by definition, does not apply). This has
resulted in an abridgement of the freedom of contract in modern liberal
society."_ Thus it is possible to argue for a _"civilised form of contractual
slavery."_ ["J. Philmore,", **Op. Cit.**]

So accurate and logical was Ellerman's article that many of its readers were
convinced it **was** written by a right-"libertarian" (including, we have to
say, us!). One such writer was Carole Pateman, who correctly noted that
_"[t]here is a nice historical irony here. In the American South, slaves were
emancipated and turned into wage labourers, and now American contractarians
argue that all workers should have the opportunity to turn themselves into
civil slaves."_ [**Op. Cit.**, p. 63]).

The aim of Ellerman's article was to show the problems that employment (wage
labour) presents for the concept of self-government and how contract need not
result in social relationships based on freedom. As "Philmore" put it, _"[a]ny
thorough and decisive critique of voluntary slavery or constitutional non-
democratic government would carry over to the employment contract -- which is
the voluntary contractual basis for the free-market free-enterprise system.
Such a critique would thus be a **reductio ad absurdum**."_ As _"contractual
slavery"_ is an _"extension of the employer-employee contract,"_ he shows that
the difference between wage labour and slavery is the time scale rather than
the principle or social relationships involved. [**Op. Cit.**] This explains
why the early workers' movement called capitalism _**"wage slavery"**_ and why
anarchists still do. It exposes the unfree nature of capitalism and the
poverty of its vision of freedom. While it is possible to present wage labour
as "freedom" due to its "consensual" nature, it becomes much harder to do so
when talking about slavery or dictatorship (and let us not forget that Nozick
also had no problem with autocracy -- see [section B.4](secB4.md)). Then the
contradictions are exposed for all to see and be horrified by.

All this does not mean that we must reject free agreement. Far from it! Free
agreement is **essential** for a society based upon individual dignity and
liberty. There are a variety of forms of free agreement and anarchists support
those based upon co-operation and self-management (i.e. individuals working
together as equals). Anarchists desire to create relationships which reflect
(and so express) the liberty that is the basis of free agreement. Capitalism
creates relationships that deny liberty. The opposition between autonomy and
subjection can only be maintained by modifying or rejecting contract theory,
something that capitalism cannot do and so the right-wing "libertarian"
rejects autonomy in favour of subjection (and so rejects socialism in favour
of capitalism).

So the real contrast between genuine libertarians and right-"libertarians" is
best expressed in their respective opinions on slavery. Anarchism is based
upon the individual whose individuality depends upon the maintenance of free
relationships with other individuals. If individuals deny their capacities for
self-government through a contract the individuals bring about a qualitative
change in their relationship to others -- freedom is turned into mastery and
subordination. For the anarchist, slavery is thus the paradigm of what freedom
is **not**, instead of an exemplification of what it is (as
right-"libertarians" state). As Proudhon argued:

> _"If I were asked to answer the following question: What is slavery? and I
should answer in one word, It is murder, my meaning would be understood at
once. No extended argument would be required to show that the power to take
from a man his thought, his will, his personality, is a power of life and
death; and that to enslave a man is to kill him."_ [**What is Property?**, p.
37]

In contrast, the right-"libertarian" effectively argues that "I support
slavery because I believe in liberty." It is a sad reflection of the ethical
and intellectual bankruptcy of our society that such an "argument" is actually
proposed by some people under the name of liberty. The concept of "slavery as
freedom" is far too Orwellian to warrant a critique -- we will leave it up to
right-"libertarians" to corrupt our language and ethical standards with an
attempt to prove it.

From the basic insight that slavery is the opposite of freedom, the anarchist
rejection of authoritarian social relations quickly follows:

> _"Liberty is inviolable. I can neither sell nor alienate my liberty; every
contract, every condition of a contract, which has in view the alienation or
suspension of liberty, is null: the slave, when he plants his foot upon the
soil of liberty, at that moment becomes a free man . . . Liberty is the
original condition of man; to renounce liberty is to renounce the nature of
man: after that, how could we perform the acts of man?"_ [P.J. Proudhon, **Op.
Cit.**, p. 67]

The employment contract (i.e. wage slavery) abrogates liberty. It is based
upon inequality of power and _"exploitation is a consequence of the fact that
the sale of labour power entails the worker's subordination."_ [Carole
Pateman, **Op. Cit.**, p. 149] Hence Proudhon's support for self-management
and opposition to capitalism -- any relationship that resembles slavery is
illegitimate and no contract that creates a relationship of subordination is
valid. Thus in a truly anarchistic society, slave contracts would be
unenforceable -- people in a truly free (i.e. non-capitalist) society would
**never** tolerate such a horrible institution or consider it a valid
agreement. If someone was silly enough to sign such a contract, they would
simply have to say they now rejected it in order to be free -- such contracts
are made to be broken and without the force of a law system (and private
defence firms) to back it up, such contracts will stay broken.

The right-"libertarian" support for slave contracts (and wage slavery)
indicates that their ideology has little to do with liberty and far more to do
with justifying property and the oppression and exploitation it produces.
Their theoretical support for permanent and temporary voluntary slavery and
autocracy indicates a deeper authoritarianism which negates their claims to be
libertarians.

[‹ F.1 Are "anarcho"-capitalists really anarchists?](secF1.md "Go to
previous page" ) [up](secFcon.md "Go to parent page" ) [F.3 Why do
anarcho"-capitalists place little or no value on equality? ›](secF3.md "Go
to next page" )

