Subroutine readinput(ameam,npart,volume,masse,nvec,ndim,npas,dt,dx,reall,options,rcut)

  !Lit les donnees sur fichier externe.
  !local variables
  !ameam(2): parametres du modele meam
  !eneropt: methode de calcul de l'energie
  !npart: nombre de particules
  !volume: volume du systeme 
  !masse: masse des particules
  !nvec:nombre de vecteurs de base
  !ndim: dimensionlite de l'espace
  !posopt: type de reseau des  positions initiales
  !velopt: mode d'initialisation des vitesses
  !potopt: type de potentiel
  !npas: nombre de pas
  !dx: variation pour test des forces
  !reall:cote de la boite de simulation
  use types_def
  IMPLICIT NONE
  !input
  type(options_type) :: options
  INTEGER :: npart,nvec,ndim,npas
  DOUBLE PRECISION :: ameam(2),volume,masse,dt,dx,reall,rcut
  CHARACTER*10 :: eneropt,posopt,velopt,forcopt,potopt
  !local variables
  Namelist /input_data/ameam,npart,volume,masse,nvec,ndim,npas,dt,dx,eneropt,posopt,velopt,&
&                      forcopt,rcut,potopt
  INTEGER :: inunit=5, outunit=6
  READ(unit=inunit,nml=input_data)
  WRITE(unit=outunit,nml=input_data)
  reall=volume**(1.d0/3.d0)
  options%eneropt=eneropt
  options%posopt=posopt
  options%velopt=velopt
  options%forcopt=forcopt  
  options%potopt=potopt
  RETURN
END SUBROUTINE readinput


