// SPDX-License-Identifier: LGPL-3.0-or-later
/*
 * libopenraw - canon/matrices.rs
 *
 * Copyright (C) 2022-2025 Hubert Figuière
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

use crate::canon;
use crate::colour::BuiltinMatrix;
use crate::TypeId;

lazy_static::lazy_static! {
    pub(super) static ref MATRICES: [BuiltinMatrix; 121] = [
    /* CRW */
    BuiltinMatrix::new( canon!(EOS_D30),
      0,
      0,
      [ 9805, -2689, -1312, -5803, 13064, 3068, -2438, 3075, 8775 ] ),
    BuiltinMatrix::new( canon!(EOS_D60),
      0,
      0xfa0,
      [ 6188, -1341, -890, -7168, 14489, 2937, -2640, 3228, 8483 ] ),
    BuiltinMatrix::new( canon!(EOS_10D),
      0,
      0xfa0,
      [ 8197, -2000, -1118, -6714, 14335, 2592, -2536, 3178, 8266 ] ),
    BuiltinMatrix::new( canon!(EOS_300D),
      0,
      0xfa0,
      [ 8197, -2000, -1118, -6714, 14335, 2592, -2536, 3178, 8266 ] ),
//    BuiltinMatrix::new( canon!(G1),
//      0,
//      0,
//	[ -4778, 9467, 2172, 4743, -1141, 4344, -5146, 9908, 6077, -1566, 11051, 557 ] ),
    BuiltinMatrix::new( canon!(G2),
      0,
      0,
      [ 9087, -2693, -1049, -6715, 14382, 2537, -2291, 2819, 7790 ] ),
    BuiltinMatrix::new( canon!(G3),
      0,
      0,
      [ 9212, -2781, -1073, -6573, 14189, 2605, -2300, 2844, 7664 ] ),
    BuiltinMatrix::new( canon!(G5),
      0,
      0,
      [ 9757, -2872, -933, -5972, 13861, 2301, -1622, 2328, 7212 ] ),
    BuiltinMatrix::new( canon!(G6),
      0,
      0,
      [ 9877, -3775, -871, -7613, 14807, 3072, -1448, 1305, 7485 ] ),
    BuiltinMatrix::new( canon!(PRO1),
      0,
      0,
      [ 10062, -3522, -999, -7643, 15117, 2730, -765, 817, 7323 ] ),
    BuiltinMatrix::new( canon!(S30),
      31,
      0,
      [ 10566, -3652, -1129, -6552, 14662, 2006, -2197, 2581, 7670 ] ),
    BuiltinMatrix::new( canon!(S40),
      0,
      0,
      [ 8510, -2487, -940, -6869, 14231, 2900, -2318, 2829, 9013 ] ),
    BuiltinMatrix::new( canon!(S45),
      129,
      0,
      [ 8163, -2333, -955, -6682, 14174, 2751, -2077, 2597, 8041 ] ),
    BuiltinMatrix::new( canon!(S50),
      129,
      0,
      [ 8882, -2571, -863, -6348, 14234, 2288, -1516, 2172, 6569 ] ),
    BuiltinMatrix::new( canon!(S60),
      129,
      0,
      [ 8795, -2482, -797, -7804, 15403, 2573, -1422, 1996, 7082 ] ),
    BuiltinMatrix::new( canon!(S70),
      129,
      0,
      [ 9976, -3810, -832, -7115, 14463, 2906, -901, 989, 7889 ] ),
    /* TIF */
    BuiltinMatrix::new( canon!(EOS_1DS),
      0,
      0xe20,
      [ 4374, 3631, -1743, -7520, 15212, 2472, -2892, 3632, 8161 ] ),
    BuiltinMatrix::new( canon!(EOS_1D),
      0,
      0xe20,
      [ 6806, -179, -1020, -8097, 16415, 1687, -3267, 4236, 7690 ] ),
    /* CR2 */
    BuiltinMatrix::new( canon!(EOS_1DMKII),
      127,
      0xe80,
      [ 6264, -582, -724, -8312, 15948, 2504, -1744, 1919, 8664 ] ),
    BuiltinMatrix::new( canon!(EOS_1DMKIIN),
      0,
      0xe80,
      [ 6240, -466, -822, -8180, 15825, 2500, -1801, 1938, 8042 ] ),
    BuiltinMatrix::new( canon!(EOS_1DMKIII),
      1023,
      0xe80,
      [ 6291, -540, -976, -8350, 16145, 2311, -1714, 1858, 7326 ] ),
    BuiltinMatrix::new( canon!(EOS_1DMKIV),
      0,
      0x3bb0,
      [ 6014, -220, -795, -4109, 12014, 2361, -561, 1824, 5787 ] ),
    BuiltinMatrix::new( canon!(EOS_1DSMKII),
      126,
      0xe80,
      [ 6517, -602, -867, -8180, 15926, 2378, -1618, 1771, 7633 ] ),
    BuiltinMatrix::new( canon!(EOS_1DSMKIII),
      0,
      0x3bb0,
      [ 5859, -211, -930, -8255, 16017, 2353, -1732, 1887, 7448 ] ),
    BuiltinMatrix::new( canon!(EOS_1DX),
      0,
      0x3c4e,
      [ 6847, -614, -1014, -4669, 12737, 2139, -1197, 2488, 6846 ] ),
    BuiltinMatrix::new( canon!(EOS_1DXMKII),
      0,
      0x3c4e,
      [ 7596, -978, -967, -4808, 12571, 2503, -1398, 2567, 5752 ] ),
    BuiltinMatrix::new( canon!(EOS_20D),
      126,
      0xfff,
      [ 6599, -537, -891, -8071, 15783, 2424, -1983, 2234, 7462 ] ),
    BuiltinMatrix::new( canon!(EOS_20DA),
      0,
      0,
      [ 14155, -5065, -1382, -6550, 14633, 2039, -1623, 1824, 6561 ] ),
    BuiltinMatrix::new( canon!(EOS_30D),
      0,
      0,
      [ 6257, -303, -1000, -7880, 15621, 2396, -1714, 1904, 7046 ] ),
    BuiltinMatrix::new( canon!(EOS_350D),
      255,
      0xfff,
      [ 6018, -617, -965, -8645, 15881, 2975, -1530, 1719, 7642 ] ),
    BuiltinMatrix::new( canon!(EOS_40D),
      1021,
      0x3f60,
      [ 6071, -747, -856, -7653, 15365, 2441, -2025, 2553, 7315 ] ),
    BuiltinMatrix::new( canon!(EOS_400D),
      0,
      0xe8e,
      [ 7054, -1501, -990, -8156, 15544, 2812, -1278, 1414, 7796 ] ),
    BuiltinMatrix::new( canon!(EOS_450D),
      0,
      0x390d,
      [ 5784, -262, -821, -7539, 15064, 2672, -1982, 2681, 7427 ] ),
    BuiltinMatrix::new( canon!(EOS_50D),
      0,
      0x3d93,
      [ 4920, 616, -593, -6493, 13964, 2784, -1774, 3178, 7005 ] ),
    BuiltinMatrix::new( canon!(EOS_500D),
      0,
      0x3479,
      [ 4763, 712, -646, -6821, 14399, 2640, -1921, 3276, 6561 ] ),
    BuiltinMatrix::new( canon!(EOS_550D),
      0,
      0x3dd7,
      [ 6941, -1164, -857, -3825, 11597, 2534, -416, 1540, 6039 ] ),
    BuiltinMatrix::new( canon!(EOS_600D),
      0,
      0x3510,
      [ 6461, -907, -882, -4300, 12184, 2378, -819, 1944, 5931 ] ),
    BuiltinMatrix::new( canon!(EOS_60D),
      0,
      0x2ff7,
      [ 6719, -994, -925, -4408, 12426, 2211, -887, 2129, 6051 ] ),
    BuiltinMatrix::new( canon!(EOS_650D),
      0,
      0x354d,
      [ 6602, -841, -939, -4472, 12458, 2247, -975, 2039, 6148 ] ),
    BuiltinMatrix::new( canon!(EOS_700D),
      0,
      0x3c00,
      [ 6602, -841, -939, -4472, 12458, 2247, -975, 2039, 6148 ] ),
    BuiltinMatrix::new( canon!(EOS_80D),
      0,
      0,
      [ 7457,-671,-937,-4849,12495,2643,-1213,2354,5492 ] ),
    BuiltinMatrix::new( canon!(EOS_800D),
      0,
      0,
      [ 6970, -512, -968, -4425, 12161, 2553, -739, 1982, 5601 ] ),
    BuiltinMatrix::new( canon!(EOS_100D),
      0,
      0x350f,
      [ 6602, -841, -939, -4472, 12458, 2247, -975, 2039, 6148 ] ),
    BuiltinMatrix::new( canon!(EOS_200D),
      0,
      0x350f,
      [ 7377, -742, -998, -4235, 11981, 2549, -673, 1918, 5538 ] ),
    BuiltinMatrix::new( canon!(EOS_1000D),
      0,
      0xe43,
      [ 6771, -1139, -977, -7818, 15123, 2928, -1244, 1437, 7533 ] ),
    BuiltinMatrix::new( canon!(EOS_1100D),
      0,
      0x3510,
      [ 6444, -904, -893, -4563, 12308, 2535, -903, 2016, 6728 ] ),
    BuiltinMatrix::new( canon!(EOS_100D),
      0,
      0x3806,
      [ 6602, -841, -939, -4472, 12458, 2247, -975, 2039, 6148 ] ),
    BuiltinMatrix::new( canon!(EOS_1200D), // Rebel T5
      0,
      0x37c2,
      [ 6461, -907, -882, -4300, 12184, 2378, -819, 1944, 5931 ] ),
    BuiltinMatrix::new( canon!(EOS_1300D), // Rebel T6
      0,
      0x3510,
      [ 6939, -1016, -866, -4428, 12473, 2177, -1175, 2178, 6162 ] ),
    BuiltinMatrix::new( canon!(EOS_2000D), // Rebel T7
      0,
      0,
      [ 8532, -701, -1167, -4095, 11879, 2508, -797, 2424, 7010 ] ),
    BuiltinMatrix::new( canon!(EOS_3000D), // 4000D, Rebel T100
      0,
      0,
      [ 6939, -1016, -866, -4428, 12473, 2177, -1175, 2178, 6162 ] ),
    BuiltinMatrix::new( canon!(EOS_5D),
      0,
      0xe6c,
      [ 6347, -479, -972, -8297, 15954, 2480, -1968, 2131, 7649 ] ),
    BuiltinMatrix::new( canon!(EOS_5DMKII),
      0,
      0x3cf0,
      [ 4716, 603, -830, -7798, 15474, 2480, -1496, 1937, 6651 ] ),
    BuiltinMatrix::new( canon!(EOS_5DMKIII),
      0,
      0,
      [ 6722, -635, -963, -4287, 12460, 2028, -908, 2162, 5668 ] ),
    BuiltinMatrix::new( canon!(EOS_5DMKIV),
      0,
      0x3bb0,
      [  6014, -220, -795, -4109, 12014, 2361, -561, 1824, 5787 ] ),
    BuiltinMatrix::new( canon!(EOS_5DS),
      0,
      0xe6c,
      [ 6250, -711, -808, -5153, 12794, 2636, -1249, 2198, 5610 ] ),
    BuiltinMatrix::new( canon!(EOS_5DS_R),
      0,
      0xe6c,
      [ 6250, -711, -808, -5153, 12794, 2636, -1249, 2198, 5610 ] ),
    BuiltinMatrix::new( canon!(EOS_6D),
      0,
      0x3c82,
      [ 7034, -804, -1014, -4420, 12564, 2058, -851, 1994, 5758 ] ),
    BuiltinMatrix::new( canon!(EOS_6DMKII),
      0,
      0,
      [ 6875, -970, -932, -4691, 12459, 2501, -874, 1953, 5809 ] ),
    BuiltinMatrix::new( canon!(EOS_7D),
      0,
      0x3510,
      [ 6844, -996, -856, -3876, 11761, 2396, -593, 1772, 6198 ] ),
    BuiltinMatrix::new( canon!(EOS_7DMKII),
      0,
      0x3510,
      [ 7268, -1082, -969, -4186, 11839, 2663, -825, 2029, 5839 ] ),
    BuiltinMatrix::new( canon!(EOS_70D),
      0,
      0x3bc7,
      [ 7034, -804, -1014, -4420, 12564, 2058, -851, 1994, 5758 ] ),
    BuiltinMatrix::new( canon!(EOS_750D),
      0,
      0x368e,
      [ 6362, -823, -847, -4426, 12109, 2616, -743, 1857, 5635 ] ),
    BuiltinMatrix::new( canon!(EOS_760D),
      0,
      0x350f,
      [ 6362, -823, -847, -4426, 12109, 2616, -743, 1857, 5635 ] ),
    BuiltinMatrix::new( canon!(EOS_77D),
      0,
      0,
      [ 7377, -742, -998, -4235, 11981, 2549, -673, 1918, 5538 ] ),
    BuiltinMatrix::new( canon!(EOS_M),
      0,
      0,
      [ 6602, -841, -939, -4472, 12458, 2247, -975, 2039, 6148 ] ),
    BuiltinMatrix::new( canon!(EOS_M2),
      0,
      0,
      [ 6400, -480, -888, -5294, 13416, 2047, -1296, 2203, 6137 ] ),
    BuiltinMatrix::new( canon!(EOS_M3),
      0,
      0,
      [ 6362, -823, -847, -4426, 12109, 2616, -743, 1857, 5635 ] ),
    BuiltinMatrix::new( canon!(EOS_M5),
      0,
      0,
      [ 8532, -701, -1167, -4095, 11879, 2508, -797, 2424, 7010 ] ),
    BuiltinMatrix::new( canon!(EOS_M6),
      0,
      0,
      [ 8532, -701, -1167, -4095, 11879, 2508, -797, 2424, 7010 ] ),
    BuiltinMatrix::new( canon!(EOS_M10),
      0,
      0,
      [ 6400, -480, -888, -5294, 13416, 2047, -1296, 2203, 6137 ] ),
    BuiltinMatrix::new( canon!(EOS_M100),
      0,
      0,
      [ 8532, -701, -1167, -4095, 11879, 2508, -797, 2424, 7010 ] ),
    BuiltinMatrix::new( canon!(G9),
      0,
      0,
      [ 7368, -2141, -598, -5621, 13254, 2625, -1418, 1696, 5743 ] ),
    BuiltinMatrix::new( canon!(G10),
      0,
      0,
      [ 11093, -3906, -1028, -5047, 12492, 2879, -1003, 1750, 5561 ] ),
    BuiltinMatrix::new( canon!(G11),
      120,
      4095,
      [ 12177, -4817, -1069, -1612, 9864, 2049, -98, 850, 4471 ] ),
    BuiltinMatrix::new( canon!(G12),
      0,
      0,
      [ 13244, -5501, -1248, -1508, 9858, 1935, -270, 1083, 4366 ] ),
    BuiltinMatrix::new( canon!(G15),
      0,
      0,
      [ 7474, -2301, -567, -4056, 11456, 2975, -222, 716, 4181 ] ),
    BuiltinMatrix::new( canon!(G16),
      0,
      0,
      [ 8020, -2687, -682, -3704, 11879, 2052, -965, 1921, 5556 ] ),
    BuiltinMatrix::new( canon!(G1X),
      0,
      0,
      [ 7378, -1255, -1043, -4088, 12251, 2048, -876, 1946, 5805 ] ),
    BuiltinMatrix::new( canon!(G1XMKII),
      0,
      0,
      [ 7378, -1255, -1043, -4088, 12251, 2048, -876, 1946, 5805 ] ),
    BuiltinMatrix::new( canon!(G1XMKIII),
      0,
      0,
      [ 8532, -701, -1167, -4095, 11879, 2508, -797, 2424, 7010 ] ),
    BuiltinMatrix::new( canon!(G3X),
      0,
      0,
      [ 9701, -3857, -921, -3149, 11537, 1817, -786, 1817, 5147 ] ),
    BuiltinMatrix::new( canon!(G5X),
      0,
      0,
      [ 9602, -3823, -937, -2984, 11495, 1675, -407, 1415, 5049 ] ),
    BuiltinMatrix::new( canon!(G7X),
      0,
      0,
      [ 9602, -3823, -937, -2984, 11495, 1675, -407, 1415, 5049 ] ),
    BuiltinMatrix::new( canon!(G7XMKII),
      0,
      0,
      [ 9602, -3823, -937, -2984, 11495, 1675, -407, 1415, 5049 ] ),
    BuiltinMatrix::new( canon!(G9X),
      0,
      0,
      [ 9602, -3823, -937, -2984, 11495, 1675, -407, 1415, 5049 ] ),
    BuiltinMatrix::new( canon!(G9XMKII),
      0,
      0,
      [ 10056, -4131, -944, -2576, 11143, 1625, -238, 1294, 5179] ),
    BuiltinMatrix::new( canon!(S90),
      0,
      0,
      [ 12374, -5016, -1049, -1677, 9902, 2078, -83, 852, 4683 ] ),
    BuiltinMatrix::new( canon!(S95),
      0,
      0,
      [ 13440, -5896, -1279, -1236, 9598, 1931, -180, 1001, 4651 ] ),
    BuiltinMatrix::new( canon!(S100),
      0,
      0,
      [ 7968, -2565, -636, -2873, 10697, 2513, 180, 667, 4211 ] ),
    BuiltinMatrix::new( canon!(S100V),
      0,
      0,
      [ 7968, -2565, -636, -2873, 10697, 2513, 180, 667, 4211 ] ),
    BuiltinMatrix::new( canon!(S110),
      0,
      0,
      [ 8039, -2643, -654, -3783, 11230, 2930, -206, 690, 4194 ] ),
    BuiltinMatrix::new( canon!(S120),
      0,
      0,
      [ 6961, -1685, -695, -4625, 12945, 1836, -1114, 2152, 5518 ] ),
    BuiltinMatrix::new( canon!(SX50_HS),
      0,
      0,
      [ 12432, -4753, -1247, -2110, 10691, 1629, -412, 1623, 4926 ] ),
    BuiltinMatrix::new( canon!(SX60_HS),
      0,
      0,
      [ 13161, -5451, -1344, -1989, 10654, 1531, -47, 1271, 4955 ] ),
    BuiltinMatrix::new( canon!(SX1_IS),
      0,
      0,
      [ 6578, -259, -502, -5974, 13030, 3309, -308, 1058, 4970 ] ),

    /* CR3 */
    BuiltinMatrix::new( canon!(EOS_M200),
      0,
      0,
      [ 10463, -2173, -1437, -4856, 12635, 2482, -1216, 2915, 7237 ] ),
    BuiltinMatrix::new( canon!(EOS_M50),
      0,
      0,
      [ 8532, -701, -1167, -4095, 11879, 2508, -797, 2424, 7010 ] ),
    BuiltinMatrix::new( canon!(EOS_M50MKII),
      0,
      0,
      [ 10463, -2173, -1437, -4856, 12635, 2482, -1216, 2915, 7237 ] ),
    BuiltinMatrix::new( canon!(EOS_M6MKII),
      0,
      0,
      [ 11498, -3759, -1516, -5073, 12954, 2349, -892, 1867, 6118 ] ),
    BuiltinMatrix::new( canon!(EOS_90D),
      0,
      0,
      [ 11498, -3759, -1516, -5073, 12954, 2349, -892, 1867, 6118 ] ),
    BuiltinMatrix::new( canon!(EOS_R),
      0,
      0,
      [ 6446, -366, -864, -4436, 12204, 2513, -952, 2496, 6348 ] ),
    BuiltinMatrix::new( canon!(EOS_RP),
      0,
      0,
      [ 8608, -2097, -1178, -5425, 13265, 2383, -1149, 2238, 5680 ] ),
    BuiltinMatrix::new( canon!(EOS_R3),
      0,
      0,
      [ 9423, -2839, -1195, -4532, 12377, 2415, -483, 1374, 5276 ] ),
    BuiltinMatrix::new( canon!(EOS_R5),
      0,
      0,
      [ 9766, -2953, -1254, -4276, 12116, 2433, -437, 1336, 5131 ] ),
    BuiltinMatrix::new( canon!(EOS_R5MKII),
      0,
      0,
      [ 9396, -2597, -1207, -4408, 12296, 2369, -505, 1575, 6077 ] ),
    BuiltinMatrix::new( canon!(EOS_R50),
      0,
      0,
      [ 9269, -2012, -1107, -3990, 11762, 2527, -569, 2093, 4913 ] ),
    BuiltinMatrix::new( canon!(EOS_R50V),
      0,
      0,
      [ 9089, -1810, -1209, -4294, 12116, 2454, -497, 1862, 4923 ] ),
    BuiltinMatrix::new( canon!(EOS_R6),
      0,
      0,
      [ 8293, -1611, -1132, -4759, 12711, 2275, -1013, 2415, 5509 ] ),
    BuiltinMatrix::new( canon!(EOS_R6MKII),
      0,
      0,
      [ 9539, -2795, -1224, -4175, 11998, 2458, -465, 1755, 6048 ] ),
    BuiltinMatrix::new( canon!(EOS_R7),
      0,
      0,
      [ 10424, -3138, -1300, -4221, 11938, 2584, -547, 1658, 6183 ] ),
    BuiltinMatrix::new( canon!(EOS_R8),
      0,
      0,
      [ 9539, -2795, -1224, -4175, 11998, 2458, -465, 1755, 6048 ] ),
    BuiltinMatrix::new( canon!(EOS_R1),
      0,
      0,
      [ 9020, -2275, -1209, -4916, 12856, 2284, -922, 1953, 5928 ] ),
    BuiltinMatrix::new( canon!(EOS_R10),
      0,
      0,
      [ 9269, -2012, -1107, -3990, 11762, 2527, -569, 2093, 4913 ] ),
    BuiltinMatrix::new( canon!(EOS_R100),
      0,
      0,
      [ 8230, -1515, -1032, -4179, 12004, 2454, -649, 2076, 4711 ] ),
    BuiltinMatrix::new( canon!(SX70_HS),
      0,
      0,
      [ 18285, -8907, -1951, -1845, 10688, 1323, 364, 1101, 5139 ] ),
    BuiltinMatrix::new( canon!(EOS_250D),
      0,
      0,
      [ 9079, -1923, -1236, -4677, 12454, 2492, -922, 2319, 5565 ] ),
    BuiltinMatrix::new( canon!(EOS_850D),
      0,
      0,
      [ 9079, -1923, -1236, -4677, 12454, 2492, -922, 2319, 5565 ] ),
    BuiltinMatrix::new( canon!(G5XMKII),
      0,
      0,
      [ 11629, -5713, -914, -2706, 11090, 1842, -206, 1225, 5515 ] ),
    BuiltinMatrix::new( canon!(G7XMKIII),
      0,
      0,
      [ 11629, -5713, -914, -2706, 11090, 1842, -206, 1225, 5515 ] ),
    BuiltinMatrix::new( canon!(EOS_1DXMKIII),
      0,
      0,
      [ 8971, -2022, -1242, -5405, 13249, 2380, -1280, 2483, 6072 ] ),
    BuiltinMatrix::new( canon!(V1),
      0,
      0,
      [ 12600, -4747, -2027, -6110, 15868, -28, 110, 479, 6011 ] ),
    ];

}
