/*
 * Copyright (C) 2000-2024 the xine project
 *
 * This file is part of xine, a unix video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 * all the various actions for the gui (play, stop, open, pause...)
 *
 */

#ifndef ACTIONS_H
#define ACTIONS_H

/* see gui_nextprev below. */
#define GUI_NEXT(gui)  ((gui)->nextprev + 2)
#define GUI_PREV(gui)  ((gui)->nextprev + 0)
#define GUI_RESET(gui) ((gui)->nextprev + 1)

/* windows */
void gui_raise_window (gGui_t *gui, xitk_window_t *xwin);
/** return layer mode 0 (off), -1 (generic on), > 0 (level).
 *  if not NULL, also apply this to xwin. */
int gui_layer_above (gGui_t *gui, xitk_window_t *xwin);

/* playlist */
void gui_display_logo (gGui_t *gui);
int gui_xine_play (gGui_t *gui, xine_stream_t *stream, int start_pos, int start_time, int update_mmk);
int gui_xine_open_and_play (gGui_t *gui, const char *mrl, const char *sub, int start_pos,
    int start_time, int av_offset, int spu_offset, int report_error);
void gui_dndcallback (void *gui, const char *filename);
void gui_nextprev_mrl (xitk_widget_t *w, void *gui_nextprev);

void gui_pl_updated (gGui_t *gui, int mmk_changed_flags);
void gui_file_selector (gGui_t *gui);

/* main ctrl */
void gui_exit (xitk_widget_t *w, void *gui);
void gui_exit_2 (gGui_t *gui); /** << internal use */
void gui_stop (xitk_widget_t *w, void *gui);
void gui_close (xitk_widget_t *w, void *gui);
void gui_pause (xitk_widget_t *w, void *gui, int state, unsigned int modifier);
void gui_eject (xitk_widget_t *w, void *gui);
void gui_nextprev_speed (xitk_widget_t *w, void *gui_nextprev);
void gui_set_current_position (gGui_t *gui, int pos);
void gui_seek_relative (gGui_t *gui, int off_sec);
/** return 0 (fail), 1 (ok), 2 (pos before running seek), 3 (pos before gapless switch), 4 (last known) */
int gui_xine_get_pos_length (gGui_t *gui, xine_stream_t *stream, int pos_time_length[3]);

/* video */
void gui_set_fullscreen_mode (xitk_widget_t *w, void *gui);
void gui_toggle_aspect (gGui_t *gui, int aspect);

/* audio */
void gui_direct_change_audio_channel (xitk_widget_t *w, void *gui, int value);
void gui_nextprev_audio_channel (xitk_widget_t *w, void *gui_nextprev);
#define GUI_AUDIO_VOL_RELATIVE (1000000)
/** redirects to gui_set_amp_level () following gui->mixer.type_volume.
 *  0..100 or GUI_AUDIO_VOL_RELATIVE + diff. */
int gui_set_audio_vol (gGui_t *gui, int value);
/** 0..[100]..200 or GUI_AUDIO_VOL_RELATIVE + diff. */
int gui_set_amp_level (gGui_t *gui, int value);

/* subtitle */
void gui_direct_change_spu_channel (xitk_widget_t *w, void *gui, int value);
void gui_nextprev_spu_channel (xitk_widget_t *w, void *gui_nextprev);
void gui_select_sub (gGui_t *gui);

size_t gui_lang_str (gGui_t *gui, char buf[XINE_LANG_MAX], unsigned int audio0_spu1);

/* anim */
void visual_anim_init (gGui_t *gui);
void visual_anim_done (gGui_t *gui);
/** add == 0: replace first one, NULL means default then.
 *  return count of animations. */
int visual_anim_add  (gGui_t *gui, const char *mrl, int add);
void visual_anim_play (gGui_t *gui, int stop_play_next);

#endif
