/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


/*
 * @test
 *
 * @summary converted from VM Testbase nsk/jvmti/PopFrame/popframe002.
 * VM Testbase keywords: [quick, jpda, jvmti, noras]
 * VM Testbase readme:
 * DESCRIPTION
 *     This test checks that the JVMTI function PopFrame() correctly
 *     returns the following errors:
 *      - JVMTI_ERROR_INVALID_THREAD;
 *      - JVMTI_ERROR_THREAD_NOT_SUSPENDED
 *     and no JVMTI events will be generated by the function.
 *     The test creates an instance of inner class popFrameCls and start
 *     it in a separate thread. Then the test tries to pop frame with
 *     the following erroneous thread's parameter of the PopFrame():
 *     - NULL pointer to the thread;
 *     - an invalid thread;
 *     - the non suspended popFrameCls' thread.
 * COMMENTS
 *     The test was changed due to the bug 4448675.
 *     Ported from JVMDI.
 *
 * @library /vmTestbase
 *          /test/lib
 * @run driver jdk.test.lib.FileInstaller . .
 * @run main/othervm/native -agentlib:popframe002 nsk.jvmti.PopFrame.popframe002
 */

