#!/usr/bin/python3

import onnxruntime as rt
import numpy as np

# step 2: load with onnxruntime and do the inference
print('ORT: available providers:', rt.get_available_providers())
session = rt.InferenceSession('test_model.onnx', providers=rt.get_available_providers())
print('ORT: loaded the dummy network')
input_name = session.get_inputs()[0].name
inputs_onnx = {'feature': np.random.randn(1, 128).astype(np.float32)}
pred_onnx = session.run(None, inputs_onnx)[0]
print('pred_onnx:', pred_onnx, 'shape:', pred_onnx.shape)
assert pred_onnx.shape == (1, 1)

print('Test OK')
