## Copyright (C) 1995-2007 R Core Team
## Copyright (C) 2019, 2023, 2024 Andrew Janke
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; If not, see <http://www.gnu.org/licenses/>.

# This is based on the co2 dataset from R’s datasets package

classdef co2 < tblish.internal.dataset

  methods

    function this = co2
      this.name = "co2";
      this.summary = "Mauna Loa Atmospheric CO2 Concentration";
    endfunction

    function out = load (this)
      co2 = [315.42, 316.31, 316.5, 317.56, 318.13, 318, 316.39, ...
        314.65, 313.68, 313.18, 314.66, 315.43, 316.27, 316.81, 317.42,  ...
        318.87, 319.87, 319.43, 318.01, 315.74, 314, 313.68, 314.84,  ...
        316.03, 316.73, 317.54, 318.38, 319.31, 320.42, 319.61, 318.42,  ...
        316.63, 314.83, 315.16, 315.94, 316.85, 317.78, 318.4, 319.53,  ...
        320.42, 320.85, 320.45, 319.45, 317.25, 316.11, 315.27, 316.53,  ...
        317.53, 318.58, 318.92, 319.7, 321.22, 322.08, 321.31, 319.58,  ...
        317.61, 316.05, 315.83, 316.91, 318.2, 319.41, 320.07, 320.74,  ...
        321.4, 322.06, 321.73, 320.27, 318.54, 316.54, 316.71, 317.53,  ...
        318.55, 319.27, 320.28, 320.73, 321.97, 322, 321.71, 321.05,  ...
        318.71, 317.66, 317.14, 318.7, 319.25, 320.46, 321.43, 322.23,  ...
        323.54, 323.91, 323.59, 322.24, 320.2, 318.48, 317.94, 319.63,  ...
        320.87, 322.17, 322.34, 322.88, 324.25, 324.83, 323.93, 322.38,  ...
        320.76, 319.1, 319.24, 320.56, 321.8, 322.4, 322.99, 323.73,  ...
        324.86, 325.4, 325.2, 323.98, 321.95, 320.18, 320.09, 321.16,  ...
        322.74, 323.83, 324.26, 325.47, 326.5, 327.21, 326.54, 325.72,  ...
        323.5, 322.22, 321.62, 322.69, 323.95, 324.89, 325.82, 326.77,  ...
        327.97, 327.91, 327.5, 326.18, 324.53, 322.93, 322.9, 323.85,  ...
        324.96, 326.01, 326.51, 327.01, 327.62, 328.76, 328.4, 327.2,  ...
        325.27, 323.2, 323.4, 324.63, 325.85, 326.6, 327.47, 327.58,  ...
        329.56, 329.9, 328.92, 327.88, 326.16, 324.68, 325.04, 326.34,  ...
        327.39, 328.37, 329.4, 330.14, 331.33, 332.31, 331.9, 330.7,  ...
        329.15, 327.35, 327.02, 327.99, 328.48, 329.18, 330.55, 331.32,  ...
        332.48, 332.92, 332.08, 331.01, 329.23, 327.27, 327.21, 328.29, ...
        329.41, 330.23, 331.25, 331.87, 333.14, 333.8, 333.43, 331.73,  ...
        329.9, 328.4, 328.17, 329.32, 330.59, 331.58, 332.39, 333.33,  ...
        334.41, 334.71, 334.17, 332.89, 330.77, 329.14, 328.78, 330.14,  ...
        331.52, 332.75, 333.24, 334.53, 335.9, 336.57, 336.1, 334.76,  ...
        332.59, 331.42, 330.98, 332.24, 333.68, 334.8, 335.22, 336.47,  ...
        337.59, 337.84, 337.72, 336.37, 334.51, 332.6, 332.38, 333.75,  ...
        334.78, 336.05, 336.59, 337.79, 338.71, 339.3, 339.12, 337.56,  ...
        335.92, 333.75, 333.7, 335.12, 336.56, 337.84, 338.19, 339.91,  ...
        340.6, 341.29, 341, 339.39, 337.43, 335.72, 335.84, 336.93, 338.04, ...
        339.06, 340.3, 341.21, 342.33, 342.74, 342.08, 340.32, 338.26,  ...
        336.52, 336.68, 338.19, 339.44, 340.57, 341.44, 342.53, 343.39,  ...
        343.96, 343.18, 341.88, 339.65, 337.81, 337.69, 339.09, 340.32,  ...
        341.2, 342.35, 342.93, 344.77, 345.58, 345.14, 343.81, 342.21,  ...
        339.69, 339.82, 340.98, 342.82, 343.52, 344.33, 345.11, 346.88,  ...
        347.25, 346.62, 345.22, 343.11, 340.9, 341.18, 342.8, 344.04,  ...
        344.79, 345.82, 347.25, 348.17, 348.74, 348.07, 346.38, 344.51,  ...
        342.92, 342.62, 344.06, 345.38, 346.11, 346.78, 347.68, 349.37,  ...
        350.03, 349.37, 347.76, 345.73, 344.68, 343.99, 345.48, 346.72,  ...
        347.84, 348.29, 349.23, 350.8, 351.66, 351.07, 349.33, 347.92,  ...
        346.27, 346.18, 347.64, 348.78, 350.25, 351.54, 352.05, 353.41,  ...
        354.04, 353.62, 352.22, 350.27, 348.55, 348.72, 349.91, 351.18,  ...
        352.6, 352.92, 353.53, 355.26, 355.52, 354.97, 353.75, 351.52,  ...
        349.64, 349.83, 351.14, 352.37, 353.5, 354.55, 355.23, 356.04,  ...
        357, 356.07, 354.67, 352.76, 350.82, 351.04, 352.69, 354.07,  ...
        354.59, 355.63, 357.03, 358.48, 359.22, 358.12, 356.06, 353.92,  ...
        352.05, 352.11, 353.64, 354.89, 355.88, 356.63, 357.72, 359.07,  ...
        359.58, 359.17, 356.94, 354.92, 352.94, 353.23, 354.09, 355.33,  ...
        356.63, 357.1, 358.32, 359.41, 360.23, 359.55, 357.53, 355.48,  ...
        353.67, 353.95, 355.3, 356.78, 358.34, 358.89, 359.95, 361.25,  ...
        361.67, 360.94, 359.55, 357.49, 355.84, 356, 357.59, 359.05,  ...
        359.98, 361.03, 361.66, 363.48, 363.82, 363.3, 361.94, 359.5,  ...
        358.11, 357.8, 359.61, 360.74, 362.09, 363.29, 364.06, 364.76,  ...
        365.45, 365.01, 363.7, 361.54, 359.51, 359.65, 360.8, 362.38,  ...
        363.23, 364.06, 364.61, 366.4, 366.84, 365.68, 364.52, 362.57,  ...
        360.24, 360.83, 362.49, 364.34]';
      date = [datetime(1959, 1, 1):calmonths(1):datetime(1997, 12, 1)]';
      out = table (date, co2);
    endfunction

  endmethods

endclassdef
