// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2009 Konrad Twardowski

#pragma once

#include <QFrame>

#ifdef Q_OS_WIN32
	#include <QStyle>
#endif // Q_OS_WIN32

#ifdef KS_KF5
	#include <KMessageWidget>
#endif // KS_KF5

class ULabel;

class InfoWidget final: public QFrame {
public:
	enum class Type { Error, Info, Warning };

	explicit InfoWidget();
	virtual ~InfoWidget() = default;

	#ifdef KS_PURE_QT
	virtual bool event(QEvent *e) override;
	#endif // KS_PURE_QT

	static InfoWidget *info(const QString &text);
	static InfoWidget *warning(const QString &text);

	void setText(const QString &text, const Type type);
private:
	Q_DISABLE_COPY(InfoWidget)
#ifdef KS_KF5
	KMessageWidget *m_messageWidget;
#else
	bool m_handlePaletteChange = false;
	Type m_type = Type::Info;
	ULabel *m_messageWidget;
	void updateColors();
#endif // KS_KF5
};
