<?xml version='1.0'?>
<!--
 * $Id: db_berkeley.xsl 3142 2007-11-15 14:09:15Z henningw $
 *
 * XSL converter script for generating module parameter templates.
 *
 * Copyright (C) 2008 Henning Westerholt
 *
 * This file is part of Kamailio, a free SIP server.
 *
 * Kamailio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * Kamailio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
-->

<!--
 * Yes, this is probably not pretty, as XSL is not the perfect tool to generate
 * C code. But we've now this infrastructure for the databases, and it works.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'
                xmlns:xi="http://www.w3.org/2001/XInclude">

<xsl:import href="common.xsl"/>
<xsl:output method="text" indent="no" omit-xml-declaration="yes"/>

    <!-- Create the file for the tables in module subdirectory -->
<xsl:template match="/">
	<xsl:variable name="createfile" select="concat($dir, concat('/', concat('db_', $prefix, '.c')))"/>
	<xsl:document href="{$createfile}" method="text" indent="no" omit-xml-declaration="yes">

<!-- doxygen header -->
<xsl:text>
/*!
 * \file
 * \ingroup db
 * \brief Database support for modules.
 *
 * Database support functions for modules.
 *
 * @cond
 * WARNING:
 * This file was autogenerated from the XML source file
</xsl:text>
<xsl:value-of select="concat(' * ', $dir, 'kamailio-', $prefix, '.xml.')"/>
<xsl:text>
 * It can be regenerated by running 'make modules' in the db/schema
 * directory of the source code. You need to have xsltproc and
 * docbook-xsl stylesheets installed.
 * ALL CHANGES DONE HERE WILL BE LOST IF THE FILE IS REGENERATED
 * @endcond
 */

</xsl:text>

<xsl:value-of select="concat('#include &quot;', 'db_', $prefix, '.h&quot;&#x0A;&#x0A;')"/>

<xsl:text>/* database variables */&#x0A;</xsl:text>
<xsl:text>/* TODO assign read-write or read-only URI, introduce a parameter in XML */&#x0A;&#x0A;</xsl:text>
<xsl:value-of select="concat('//extern str ', $prefix, '_db_url;&#x0A;')"/>
<xsl:value-of select="concat('db_con_t * ', $prefix, '_dbh = NULL;&#x0A;')"/>
<xsl:value-of select="concat('db_func_t ', $prefix, '_dbf;&#x0A;&#x0A;')"/>

<xsl:apply-templates select="/database[1]"/>

<xsl:text>
/*
 * Closes the DB connection.
 */
</xsl:text>
<xsl:value-of select="concat('void ', $prefix, '_db_close(void) {&#x0A;')"/>
<xsl:value-of select="concat('&#9;if (', $prefix, '_dbh) {&#x0A;')"/>
<xsl:value-of select="concat('&#9;&#9;', $prefix, '_dbf.close(', $prefix, '_dbh);&#x0A;')"/>
<xsl:value-of select="concat('&#9;&#9;', $prefix, '_dbh = NULL;&#x0A;&#9;}&#x0A;}&#x0A;&#x0A;')"/>

<xsl:text>
/*!
 * Initialises the DB API, check the table version and closes the connection.
 * This should be called from the mod_init function.
 *
 * \return 0 means ok, -1 means an error occurred.
 */
</xsl:text>
<xsl:value-of select="concat('int ', $prefix, '_db_init(void) {&#x0A;')"/>
<xsl:value-of select="concat('&#9;if (!', $prefix, '_db_url.s || !', $prefix, '_db_url.len) {')"/>
<xsl:text>
		LM_ERR(&quot;you have to set the db_url module parameter.\n&quot;);
		return -1;
	}
</xsl:text>
<xsl:value-of select="concat('&#9;if (db_bind_mod(&amp;', $prefix, '_db_url, &amp;', $prefix, '_dbf) &lt; 0) {')"/>
<xsl:text>
		LM_ERR(&quot;can't bind database module.\n&quot;);
		return -1;
	}
</xsl:text>
<xsl:value-of select="concat('&#9;if ((', $prefix, '_dbh = ', $prefix, '_dbf.init(&amp;', $prefix, '_db_url)) == NULL) {')"/>
<xsl:text>
		LM_ERR(&quot;can't connect to database.\n&quot;);
		return -1;
	}
</xsl:text>
<xsl:text>	if (
</xsl:text>

<!-- create the table version check -->
<xsl:for-each select="//database[1]/table">
	<xsl:variable name="table">
		<xsl:call-template name="get-name">
		</xsl:call-template>
	</xsl:variable>
	<xsl:value-of select="concat('&#9;(db_check_table_version(&amp;', $prefix, '_dbf, ', $prefix, '_dbh, &amp;', $table, '_table, ', $table, '_version) &lt; 0)')"/>
	<xsl:if test="not(position()=last())">
		<xsl:text> ||&#x0A;</xsl:text>
	</xsl:if>
</xsl:for-each>
<xsl:text>
	) {
		LM_ERR(&quot;during table version check.\n&quot;);
</xsl:text>
<xsl:value-of select="concat('&#9;&#9;', $prefix, '_db_close();')"/>
<xsl:text>
		return -1;
	}
</xsl:text>
<xsl:value-of select="concat('&#9;', $prefix, '_db_close();')"/>
<xsl:text>
	return 0;
}

</xsl:text>

<xsl:text>
/*!
 * Initialize the DB connection without checking the table version and DB URL.
 * This should be called from child_init. An already existing database
 * connection will be closed, and a new one created.
 *
 * \return 0 means ok, -1 means an error occurred.
 */
</xsl:text>
<xsl:value-of select="concat('int ', $prefix, '_db_open(void) {&#x0A;')"/>
<xsl:value-of select="concat('&#9;if (', $prefix, '_dbh) {&#x0A;')"/>
<xsl:value-of select="concat('&#9;&#9;', $prefix, '_dbf.close(', $prefix, '_dbh);&#x0A;&#9;}&#x0A;')"/>
<xsl:value-of select="concat('&#9;if ((', $prefix, '_dbh = ', $prefix, '_dbf.init(&amp;', $prefix, '_db_url)) == NULL) {')"/>
<xsl:text>
		LM_ERR(&quot;can't connect to database.\n&quot;);
		return -1;
	}
	return 0;
}

</xsl:text>

<xsl:text>
/*!
 * Update the variable length after eventual assignments from the config script.
 * This is necessary because we're using the 'str' type.
 */
</xsl:text>
<xsl:value-of select="concat('void ', $prefix, '_db_vars(void) {&#x0A;')"/>
<!-- TODO remove if case, if db_url is also set from this code -->
<xsl:value-of select="concat('&#9;if (', $prefix, '_db_url.s) ', $prefix, '_db_url.len = strlen(', $prefix, '_db_url.s);&#x0A;')"/>

<xsl:for-each select="//database[1]/table">
	<xsl:variable name="table.name">
		<xsl:call-template name="get-name">
		</xsl:call-template>
	</xsl:variable>
	<xsl:value-of select="concat('&#9;', $table.name, '_table.len = strlen(', $table.name, '_table.s',');&#x0A;')"/>
	<xsl:for-each select="column">
		<xsl:variable name="column.name">
			<xsl:call-template name="get-name"/>
		</xsl:variable>
		<xsl:value-of select="concat('&#9;', $table.name, '_', $column.name, '_col.len = strlen(', $table.name, '_', $column.name, '_col.s', ');&#x0A;')"/>
	</xsl:for-each>
</xsl:for-each>
<xsl:text>}&#x0A;</xsl:text>
		<xsl:text>&#x0A;</xsl:text>

</xsl:document>
</xsl:template>

	<!-- create table name parameter -->
	<xsl:template match="table">
	<xsl:variable name="name">
		<xsl:call-template name="get-name"/>
	</xsl:variable>

	<xsl:value-of select="concat('str ', $name, '_table = str_init(&quot;', $name, '&quot;);&#x0A;')"/>
	<xsl:text>&#x0A;</xsl:text>

	<xsl:text>/* column names */&#x0A;</xsl:text>
	<xsl:apply-imports/>

	<xsl:text>&#x0A;</xsl:text>
	<xsl:text>/* table version */&#x0A;</xsl:text>
	<xsl:apply-templates select="version"/>
	</xsl:template>

	<!-- create version parameter -->
	<xsl:template match="version">
	<xsl:variable name="table.name">
		<xsl:call-template name="get-name">
		<xsl:with-param name="select" select="parent::table"/>
	</xsl:call-template>
	</xsl:variable>
	<xsl:value-of select="concat('const unsigned int ', $table.name, '_version', ' = ')"/>
	<xsl:value-of select="text()"/>
	<xsl:text>;&#x0A;</xsl:text>
	<xsl:text>&#x0A;</xsl:text>
	</xsl:template>

	<!-- Create column parameter -->
	<xsl:template match="column">
	<xsl:variable name="table.name">
		<xsl:call-template name="get-name">
		<xsl:with-param name="select" select="parent::table"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="column.name">
		<xsl:call-template name="get-name"/>
	</xsl:variable>
	<xsl:value-of select="concat('str ', $table.name, '_', $column.name, '_col = str_init(&quot;', $column.name, '&quot;);&#x0A;')"/>
	</xsl:template>

</xsl:stylesheet>
