/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * The Original Code is Copyright (C) 2013 Blender Foundation.
 * All rights reserved.
 */

/** \file
 * \ingroup GHOST
 *
 * Declaration of GHOST_Context class.
 */

#pragma once

#include "GHOST_Context.h"

class GHOST_ContextNone : public GHOST_Context {
 public:
  GHOST_ContextNone(bool stereoVisual) : GHOST_Context(stereoVisual), m_swapInterval(1)
  {
  }

  /**
   * Dummy function
   * \return Always succeeds
   */
  GHOST_TSuccess swapBuffers();

  /**
   * Dummy function
   * \return Always succeeds.
   */
  GHOST_TSuccess activateDrawingContext();

  /**
   * Dummy function
   * \return Always succeeds.
   */
  GHOST_TSuccess releaseDrawingContext();

  /**
   * Dummy function
   * \return Always succeeds.
   */
  GHOST_TSuccess updateDrawingContext();

  /**
   * Dummy function
   * \return Always succeeds.
   */
  GHOST_TSuccess initializeDrawingContext();

  /**
   * Dummy function
   * \return Always succeeds.
   */
  GHOST_TSuccess releaseNativeHandles();

  /**
   * Dummy function
   * \return Always succeeds.
   */
  GHOST_TSuccess setSwapInterval(int interval);

  /**
   * Dummy function
   * \param intervalOut: Gets whatever was set by #setSwapInterval.
   * \return Always succeeds.
   */
  GHOST_TSuccess getSwapInterval(int &intervalOut);

 private:
  int m_swapInterval;
};
