# Set CMAKE_PREFIX_PATH with toolchain directory

if(DESKTOP)
	set(MIN_QT_VERSION 6.4)
else()
	set(MIN_QT_VERSION 6.8)
endif()

if(IOS OR ANDROID)
	if(NOT QT_HOST_PATH)
		# If no QT_HOST_PATH is set, see if it was build as part of the toolchain
		foreach(path ${CMAKE_PREFIX_PATH})
			set(QT_HOST_PATH ${path}/qt-host/)
			if(EXISTS "${QT_HOST_PATH}")
				break()
			endif()
		endforeach()
	endif()

	if(NOT EXISTS ${QT_HOST_PATH})
		message(FATAL_ERROR "QT_HOST_PATH does not exist")
	endif()

	message(STATUS "QT_HOST_PATH: ${QT_HOST_PATH}")
endif()

set(Qt Qt6)
find_package(${Qt} ${MIN_QT_VERSION} REQUIRED COMPONENTS Core Concurrent Network StateMachine CMAKE_FIND_ROOT_PATH_BOTH)
set(QT_VERSION "${Qt6Core_VERSION}")

if(NOT CONTAINER_SDK)
	list(APPEND QT_COMPONENTS LinguistTools)
endif()

if(INTEGRATED_SDK)
	if(CMAKE_BUILD_TYPE STREQUAL "DEBUG")
		list(APPEND QT_COMPONENTS Gui)
	endif()
else ()
	list(APPEND QT_COMPONENTS Svg WebSockets Qml Quick QuickControls2 QuickTemplates2 QmlWorkerScript ShaderTools)
	if(DESKTOP)
		list(APPEND QT_COMPONENTS Widgets)
	endif()
endif()

if(ANDROID OR IOS OR WINDOWS_STORE OR CMAKE_BUILD_TYPE STREQUAL "DEBUG")
	list(APPEND QT_COMPONENTS Nfc)
endif()

if(ANDROID)
	if(QT_VERSION VERSION_GREATER_EQUAL "6.10")
		list(APPEND QT_COMPONENTS CorePrivate)
	endif()
	if(INTEGRATED_SDK)
		list(APPEND QT_COMPONENTS WebSockets)
	endif()
elseif(CONTAINER_SDK)
	list(APPEND QT_COMPONENTS WebSockets)
endif()


get_filename_component(QT_INSTALL_ARCHDATA ${QT6_INSTALL_PREFIX}/${QT6_INSTALL_ARCHDATA} ABSOLUTE)
get_filename_component(QT_INSTALL_TRANSLATIONS ${QT6_INSTALL_PREFIX}/${QT6_INSTALL_TRANSLATIONS} ABSOLUTE)
message(STATUS "QT_INSTALL_ARCHDATA: ${QT_INSTALL_ARCHDATA}")
message(STATUS "QT_INSTALL_TRANSLATIONS: ${QT_INSTALL_TRANSLATIONS}")

find_package(Governikus QUIET)
if(GOVERNIKUS_QT)
	message(STATUS "Qt (Governikus): ${LIBS_REVISION}")
endif()

if(NOT DEFINED QT_INSTALL_TRANSLATIONS)
	message(FATAL_ERROR "Cannot detect QT_INSTALL_TRANSLATIONS")
endif()


if(MINGW AND NOT CMAKE_CROSSCOMPILING)
	set(tmp_crosscompile_enabled TRUE)
	set(CMAKE_CROSSCOMPILING ON)
endif()

set(MIN_OPENSSL_VERSION 1.1.1)
find_package(OpenSSL ${MIN_OPENSSL_VERSION} REQUIRED)

if(tmp_crosscompile_enabled)
	set(CMAKE_CROSSCOMPILING OFF)
endif()


if(MINGW)
	find_package(PCSC REQUIRED)
	set(WIN_DEFAULT_LIBS "-ladvapi32" "-lkernel32" "-lole32" "-lsetupapi" "-lversion" "-liphlpapi" "-ldwmapi")
elseif(MSVC OR CMAKE_CXX_SIMULATE_ID STREQUAL "MSVC")
	find_package(PCSC REQUIRED)
	set(WIN_DEFAULT_LIBS setupapi.lib version.lib iphlpapi.lib dwmapi.lib)
elseif(ANDROID)

elseif(IOS)
	find_library(IOS_ASSETSLIBRARY AssetsLibrary)
	find_library(IOS_UIKIT UIKit)
	find_library(IOS_STOREKIT StoreKit)
	find_library(IOS_MOBILECORESERVICES MobileCoreServices)
	find_library(IOS_COREFOUNDATION CoreFoundation)
	find_library(IOS_OPENGLES OpenGLES)
	find_library(IOS_FOUNDATION Foundation)
	find_library(IOS_QUARTZCORE QuartzCore)
	find_library(IOS_CORETEXT CoreText)
	find_library(IOS_COREGRAPHICS CoreGraphics)
	find_library(IOS_SECURITY Security)
	find_library(IOS_NETWORK Network)
	find_library(IOS_AUDIOTOOLBOX AudioToolbox)
	find_library(IOS_IMAGEIO ImageIO)
	find_library(IOS_CORENFC CoreNFC)
	find_library(IOS_MESSAGEUI MessageUI)
elseif(MAC)
	find_package(PCSC REQUIRED)

	find_library(OSX_USERNOTIFICATIONS UserNotifications)
	find_library(OSX_APPKIT AppKit)
	find_library(IOKIT NAMES IOKit)
	find_library(OSX_SECURITY Security)
	find_library(OSX_FOUNDATION Foundation)
	find_library(OSX_SERVICEMANAGEMENT ServiceManagement)
elseif(UNIX)
	if(LINUX OR BSD)
		find_package(PkgConfig REQUIRED)
		pkg_check_modules(UDEV IMPORTED_TARGET libudev)
		if(NOT TARGET PkgConfig::UDEV)
			message(STATUS "Hardware detection disabled - Missing libudev")
		endif()
	endif()

	find_package(PCSC REQUIRED)
endif()


if(BUILD_TESTING)
	if(CMAKE_BUILD_TYPE STREQUAL DEBUG)
		set(QT_TEST_COMPONENTS QT_COMPONENTS)
	else()
		set(QT_TEST_COMPONENTS QT_COMPONENTS_OPTIONAL)
	endif()

	list(APPEND ${QT_TEST_COMPONENTS} Test)
	if(QT_VERSION VERSION_GREATER_EQUAL "6.10")
		list(APPEND ${QT_TEST_COMPONENTS} CorePrivate)
	endif()
	if(NOT INTEGRATED_SDK)
		list(APPEND ${QT_TEST_COMPONENTS} QuickTest)
	endif()

	if(INTEGRATED_SDK)
		find_package(Threads REQUIRED)
	endif()
endif()

if(QT_COMPONENTS)
	if(CorePrivate IN_LIST QT_COMPONENTS OR CorePrivate IN_LIST QT_COMPONENTS_OPTIONAL)
		set(QT_NO_PRIVATE_MODULE_WARNING ON)
	endif()
	find_package(${Qt} ${MIN_QT_VERSION} REQUIRED COMPONENTS ${QT_COMPONENTS} OPTIONAL_COMPONENTS ${QT_COMPONENTS_OPTIONAL})
endif()

if(LINUX OR BSD)
	try_run(testResult compileResult "${CMAKE_BINARY_DIR}" "${CMAKE_DIR}/tests/openssl.cpp"
		CMAKE_FLAGS INSTALL_RPATH_USE_LINK_PATH:BOOL=ON
		LINK_LIBRARIES ${Qt}::Network OpenSSL::Crypto OpenSSL::SSL
		OUTPUT_VARIABLE runResult)
	if(NOT testResult EQUAL 0)
		message(FATAL_ERROR "Your OpenSSL library looks incompatible: ${testResult}\n${runResult}")
	endif()
endif()
