// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ConfOption_h__
#define __ConfOption_h__

#include "Puma/Array.h"
#include "Puma/StrCol.h"
#include <stdlib.h>

namespace Puma {


class ConfOption {
  const char *_name;
  Array<const char *> _args;
  
public:
  ConfOption (const char *);
  ConfOption (const char *, const char *);
  ConfOption (const char *, const char *, const char *);
  ~ConfOption ();
  
  const char *Name () const;
  unsigned Arguments () const;
  const char *Argument (unsigned) const;
  
  void addArgument (const char *);
};

inline ConfOption::ConfOption (const char *n) : _args (1, 1) 
 { _name = StrCol::dup (n); }
inline ConfOption::ConfOption (const char *n, const char *a1) : _args (1, 1) 
 { _name = StrCol::dup (n); addArgument (a1); }
inline ConfOption::ConfOption (const char *n, const char *a1, const char *a2) : _args (2, 1) 
 { _name = StrCol::dup (n); addArgument (a1); addArgument (a2); }
 
inline ConfOption::~ConfOption ()
 { delete[] _name; 
   for (unsigned i = 0; i < Arguments (); i++) 
     delete[] Argument (i);
 }

inline const char *ConfOption::Name () const 
 { return _name; }
inline unsigned ConfOption::Arguments () const
 { return _args.length (); }
inline const char *ConfOption::Argument (unsigned i) const
 { return _args.lookup (i); }
  
inline void ConfOption::addArgument (const char *a) 
 { if (a) _args.append (StrCol::dup (a)); }


} // namespace Puma

#endif /* __ConfOption_h__ */
