// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __error_sink_h__
#define __error_sink_h__

// This is an interface for classes that may be used to consume error
// messages during a process where many errors can occur like parsing
// a program.
// The error information is handed over to the ErrorSink in stream-like
// style. Different severities of errors are predefined and can be used
// to classify error information that follows. Also a location can be
// handed over to the ErrorSink to specify where the error was found
// (filename, line, etc.). The error information itself can be of any
// standard data type or anything that is "Printable".
// Specializations of this class could either build and print error
// messages or collect them for a later processing.

#include "Puma/ErrorSeverity.h"
#include "Puma/Printable.h"
#include "Puma/Location.h"

namespace Puma {


class ErrorSink {
public:
  virtual ~ErrorSink () {}
  virtual ErrorSink &operator << (const char *) = 0;
  virtual ErrorSink &operator << (long) = 0;
  virtual ErrorSink &operator << (unsigned) = 0;
  virtual ErrorSink &operator << (int) = 0;
  virtual ErrorSink &operator << (short) = 0;
  virtual ErrorSink &operator << (char) = 0;
  virtual ErrorSink &operator << (double) = 0;
  virtual ErrorSink &operator << (const ErrorSeverity &) = 0;
  virtual ErrorSink &operator << (Location) = 0;
  virtual ErrorSink &operator << (const Printable &) = 0;
  virtual ErrorSink &operator << (void (*f)(ErrorSink &)) = 0;
  virtual void endMessage () = 0;
};

void endMessage (ErrorSink &);


} // namespace Puma

#endif /* __error_sink_h__ */
