# 新酷音詞庫和注音修改教學

這份文件是給有興趣修改新酷音詞庫的人，前面是詳細的解說，後面有詳盡的[實戰演練範例](#實戰演練範例)，只要耐心看完就可以學會。

## 準備工作：

1. 你需要取得新酷音詞庫和注音設定的原始資料檔，用來修改後，產生新的詞庫。
   <!-- TODO: 更新為使用 Git 維護 -->
   <!-- 為了確保你取得的是最新版本的資料，以及方便將自己修改的部份和他人的修改整合，這個動作必須使用版本控制系統，我們是用 svn 維護，可用各種 svn 軟體來操作，在 Windows 系統上我們強烈建議使用最簡單的 [TortoiseSVN](http://sourceforge.net/project/showfiles.php?group_id=138498&package_id=151948&release_id=358765)。 -->
2. 如果你希望你做的修正可以內建於新酷音輸入法，被官方納入，請考慮參加「[新酷音詞庫團隊](https://github.com/chewing)」，你將可以把你做的修改存入官方版本之中。
3. 要加入新酷音詞庫團隊請在 [新酷音詞庫團隊](https://github.com/chewing) 專案網頁註冊新帳號。
   <!-- TODO: 更新聯絡方式 -->
   <!-- ，註冊完成後，將你的帳號寄給 pcman.tw(a)gmail.com, seamxr(a)gmail.com, 或 andyhorng168(a)gmail.com 其中之一，並且在信件標題註明 [協助新酷音詞庫] 即可。-->

<!--
## 安裝好 TortoiseSVN 後，請依照下列步驟操作

1.  找一個你想要的地方，建立名為 libchewing-data 的資料夾
2.  接下來在資料夾上面按下右鍵，選擇 SVN Checkout
3.  在接下來出現的畫面中，請在  "URL of repository" 欄位當中輸入：http://svn.openfoundry.org/libchewingdata/  按下 OK 即可
4.  接下來目錄裡面就會取得所有需要用到的原始檔
-->

## 檔案取得之後，下面是修改的教學：

進入剛剛建立的 libchewing-data 目錄，底下有 dict 子目錄，存放詞庫所需的檔案，在此簡介幾個會用到的檔案的用途：  

* `dict/chewing/word.csv`：新酷音的注音都定義在這裡
* `dict/chewing/tsi.csv`：詞庫，裡面有所有新酷音內建的詞

<!--
注意：要開始修改檔案之前，建議先在 libchewing-data 目錄上按右鍵，選 SVN Update，這個動作會從網路上檢查有沒有其他人修改過的更新，如果有會下載後整合，避免和別人已經改好的部份衝突。
-->

## 修改錯誤注音和加詞方式，規則有點複雜，但是按步驟應該不難：

當你發現新酷音有注音錯誤，或是缺少注音的情況，請依下列方式修改：

舉例： 原本的新酷音有「呢」這個字，但是打「ㄋㄜ˙」輕聲卻出不來，缺少這個注音，這時候我們要幫他加入，請用文字編輯器開啟 word.csv 檔

word.csv 的格式很簡單，每一行都是「中文字」,「0」,「打出這個字所需的注音」，例如「呢」的注音是「ㄋㄜ˙」，所以定義這個注音的那一行就應該是「呢,0,ㄋㄜ˙」，只要加入這行，就可以讓「ㄋㄜ˙」可以打出「呢」。加入 ㄋㄜ˙ 這行的時候，請用編輯器的「尋找」功能，看一下有無其他同為 ㄋㄜ˙ 的字，如果沒有，找找看有沒有 ㄋㄜ˙ 開頭的或 ㄋ 開頭，盡量跟其他注音一樣或盡量接近的排在一起，按照字母順序排好，方便其他人維護。

加入這個注音之後，還要修改 `tsi.csv` ，這是個有點大的檔案，請用剛剛推薦的文字編輯器開啟。`tsi.src` 紀錄了各個字的相關詞，以及各個同音詞和同音字的優先順序，格式解說如下：

`tsi.csv` 每一行都是 「詞」,「詞的優先順序，數字越大越優先」,「詞的注音」例如「酷音」這個詞，他的定義那行就是： __酷音,1000,ㄎㄨˋ ㄧㄣ__ 1000 是這個詞的優先順序，請注意後面的注音在每個字的注音之間要有空格，像是 「ㄎㄨˋ」「空一格」「 ㄧㄣ」優先順序的數值是用語料統計來的，不建議手動隨便修改，隨意亂改可能會導致選詞能力變差。

至於一個詞有多種注音時，應該每種注音要是獨立ㄧ行，例如「一個」一詞有「ㄧ ㄍㄜ˙」和「ㄧˊ ㄍㄜ˙」兩種念法，所以在 tsi.csv 中分別是不同的兩行：「__一個,65753,ㄧ ㄍㄜ˙__」和「 __一個,65753,ㄧˊ ㄍㄜ˙__」

大概了解檔案格式後，就開始講要怎麼加詞進去。剛剛是要加入「呢」這個詞 (字可視為只有一個字的詞)，所以要在原本就有的「呢,17247,ㄋㄜ」後面加入一行「呢,17247,ㄋㄜ˙」，其中 17247 是優先順序，這個數字當然不可能是自己亂填，要考慮很多因素：

1.  用新酷音打這個注音，看看有沒有同音的詞，如果有，請拉出選字視窗，看看有那幾個同音詞。
2.  看一下這個新加進去的詞，如果要插入到原有的這幾個同音詞之中，依照常用程度，應該要排在第幾順位，如果沒同音詞，請直接跳到步驟 5
3.  決定出新詞在同音詞之間的插入位置後，用文字編輯器的尋找功能，去找他前面一個和後面一個同音詞，並且查出它們的優先順序數值
4.  用這兩個數值平均取中間值，就是相加除以2，可以把這個數值當作詞的優先順序數值
5.  如果這個詞是由好幾個字組成的，去查這幾個字的優先順序數值，請用編輯器的尋找功能找那幾個字，通常詞的優先順序數值應該要比組成他的幾個字要低，所以取一個比那幾個字都還小的數值就可以了。而如果剛剛你在步驟 2-4 之間訂出一個過高的數值，請把他調低到比這些字都還小就可以了。**請注意這裡有個例外**：如果組成這個詞的幾個字當中，有些字幾乎很少單獨用，則這個字可以不用算進來，例如「爸」這個字通常都是用在「爸爸」一詞，很少單獨用，也就是「爸爸」一詞比組成它的「爸」字要常用，這時候不用理會「爸」這個字的優先權，而如果又有同音詞，就直接以步驟 2-4 的同音詞來排序決定即可。

摘要：只是單純要加詞，改 tsi.csv 加入就可以了，如果只是要更正字的錯誤注音，改 word.csv 就可以了。如果要新增本來沒有的注音 (破音字)，請改 word.csv 之後，再到 tsi.csv 裡面加入這個字的優先數值和新增的注音拼法。

以上修改完畢後，就可以準備輸出酷音詞庫檔，開始測試：

<!--
TODO: fixme
1.  請執行 `build_data.bat` 這個檔案，執行完畢後會在 big5 和 utf-8 子目錄下，各輸出一堆檔案。big5 下的是給舊版新酷音 Win32 (0.2.0.1 以前版本)使用，新酷音 Win32 0.2.5 以後版本，必須要使用 utf-8 底下的檔案。  
    把下列五個檔案放到 `C:\windows\system32\ime\chewing` (windows 98/ME 是 `C:\windows\system\ime\chewing`)下覆蓋原檔案就可以了：
    * `dict.dat`
    * `ph_index.dat`
    * `ch_index.dat`
    * `fonetree.dat`
    * `us_freq.dat`
2.  按 Ctrl+Alt+Delete 叫出工作管理員，找到 ChewingServer 這個程序，把他終止掉。
3.  接下來開記事本進行打字測試，看看你剛剛的修改有沒有成功，有沒有造成其他異常。
-->

完成！  

如果你是新酷音詞庫團隊的正式成員，可以把你剛剛修改好的部份，上傳到官方網站  

<!--
請在 libchewing-data 資料夾上按右鍵選擇 「SVN Commit...」，他會問你之前申請的帳號密碼，輸入之後就可以上傳了。  
-->

## 實戰演練範例：

使用者回報 打ㄎㄜˋ會出現"可" ㄇㄚˇ會出現"嗎"，如何修復？  

*   可本來就也可以唸ㄎㄜˋ，這不是注音錯誤，不必改正 `word.csv`，但是唸成ㄎㄜˋ是罕見的音，比起其他同樣唸「ㄎㄜˋ」的字，不該放在前面，所以這是優先順序錯了，罕用字不該放前面，優先順序請改 `tsi.csv`
*   開啟 `tsi.csv` 檔案後找「可」開頭的那行，用編輯器尋找可以找到，我找到以下的幾行：
    *   可,1,ㄎㄜˋ          <----- 這邊有ㄎㄜˋ，優先順序很低，是1，沒錯啊？？
    *   可,73172,ㄎㄜˇ
    *   可,73172,ㄎㄜˋ      <----- 這是罪魁禍首，難怪會有錯，這邊多了ㄧ行，重複定義，把ㄎㄜˋ又定成 73172，對罕用字來說顯然太高，又前面已經有定義優先數值為 1，此行刪除即可修復

*   打ㄇㄚˇ會出現"嗎"，這也是優先順序有問題，其他同樣唸ㄇㄚˇ的字顯然比這常用多了，所以請找到「嗎」開頭的那幾行，我找到：
    *   嗎,26437,ㄇㄚ
    *   嗎,26437,ㄇㄚ˙
    *   嗎,26437,ㄇㄚˇ
*   讀作「ㄇㄚ」的時候很常用，還可以接受，但是讀作「ㄇㄚˇ」絕對不可能比其他唸「ㄇㄚˇ」的同音詞更常用，這太罕用，免查，直接把26437 改為 「嗎 1 ㄇㄚˇ」，把優先權降到最低即可

打ㄋㄧㄢˋ沒出現常用的「唸」或者「念」，卻跑出「廿」，怎麼修？  

*   是優先順序有誤，請開 tsi.csv
*   開啟編輯器，試著用新酷音找同音詞，請打ㄋㄧㄢˋ，然後選字，我們發現列出來一堆都拼成「ㄋㄧㄢˋ」的字裡面，「廿」是最罕用的之一，但是因為這個字有「二十」的意思，還會比淰、齞等字常用，所以決定把「廿」改到「唸」的後面，「淰」的前面
*   找到「唸」，那行是：唸 994 ㄋㄧㄢˋ，優先權是 994
*   找到「淰」，那行是：淰 126 ㄋㄧㄢˋ，優先權是 126
*   再來找到我們要改的「廿」，那行是：廿 6638 ㄋㄧㄢˋ，優先權是 6638
*   問題很明顯，罕用字優先權竟然是 6638，比 994 & 126 都還高，我們要把他改成介於這兩字之間，所以取 (994 + 126) / 2 =  560，改成：廿 560 ㄋㄧㄢˋ

<!--
修改完畢，執行 `build_data.bat`，然後把產生的 dat 檔案放到 chewing 目錄下，按 Ctrl+Alt+Del 關閉 ChewingServer 後開記事本測試剛剛的結果，發現全都正常了 :)  

如果你是新酷音詞庫團隊的成員，請將你的成果 SVN Commit，並可以在 Log 裡面填寫你改了什麼  
-->

## 開始修復使用者回報的錯誤 (給專案成員看的)：

*   找尋使用者回報的問題，看有那些是還沒有人處理的，你要修理就點進去，然後按下「開啟」，接下來這個問題就會指定由你認領，負責修復，其他人就處理其他還沒人認領的問題。
*   等到修復之後，請再上來，同樣點進這個問題，然後按下「解決」按鈕，表示這個問題你已經修復。

## 附錄：參考字典/辭典

字典：

*   [國語一字多音審訂表](http://www.edu.tw/EDU_WEB/EDU_MGT/MANDR/EDU6300001/allbook/kyjd/f15.html?open)
*   [CNS11643中文全字庫](http://www.cns11643.gov.tw/web/index.jsp)
*   [教育部異體字字典](http://140.111.1.40/)

辭典：

*   [教育部重編國語辭典修訂本](http://www.sinica.edu.tw/~tdbproj/dict/)
*   [國語辭典](http://140.111.34.46/dict/)
*   [國語辭典簡編本](http://140.111.34.46/jdict/main/cover/9001.html)

如果在字詞的出處或是字義有疑義時，查證上建議使用：

*   [說文解字段注本](http://www.gg-art.com/imgbook/index_b.php?bookid=53)
*   [康熙字典](http://www.kangxizidian.com/)
