#include "com_guid.h"

#include "../../d3d11/d3d11_interfaces.h"

#include "../../dxgi/dxgi_interfaces.h"

const GUID ID3D11VkExtDevice::guid      = {0x8a6e3c42,0xf74c,0x45b7,{0x82,0x65,0xa2,0x31,0xb6,0x77,0xca,0x17}};
const GUID ID3D11VkExtContext::guid     = {0xfd0bca13,0x5cb6,0x4c3a,{0x98,0x7e,0x47,0x50,0xde,0x2c,0xa7,0x91}};
const GUID IDXGIDXVKAdapter::guid       = {0x907bf281,0xea3c,0x43b4,{0xa8,0xe4,0x9f,0x23,0x11,0x07,0xb4,0xff}};
const GUID IDXGIDXVKDevice::guid        = {0x92a5d77b,0xb6e1,0x420a,{0xb2,0x60,0xfd,0xf7,0x01,0x27,0x28,0x27}};
const GUID IDXGIVkMonitorInfo::guid     = {0xc06a236f,0x5be3,0x448a,{0x89,0x43,0x89,0xc6,0x11,0xc0,0xc2,0xc1}};
const GUID IDXGIVkInteropAdapter::guid  = {0x3a6d8f2c,0xb0e8,0x4ab4,{0xb4,0xdc,0x4f,0xd2,0x48,0x91,0xbf,0xa5}};
const GUID IDXGIVkInteropDevice::guid   = {0xe2ef5fa5,0xdc21,0x4af7,{0x90,0xc4,0xf6,0x7e,0xf6,0xa0,0x93,0x23}};
const GUID IDXGIVkInteropSurface::guid  = {0x5546cf8c,0x77e7,0x4341,{0xb0,0x5d,0x8d,0x4d,0x50,0x00,0xe7,0x7d}};
const GUID IDXGIVkSwapChain::guid       = {0x104001a6,0x7f36,0x4957,{0xb9,0x32,0x86,0xad,0xe9,0x56,0x7d,0x91}};
const GUID IWineDXGISwapChainFactory::guid = {0x53cb4ff0,0xc25a,0x4164,{0xa8,0x91,0x0e,0x83,0xdb,0x0a,0x7a,0xac}};

std::ostream& operator << (std::ostream& os, REFIID guid) {
  os << std::hex << std::setfill('0')
     << std::setw(8) << guid.Data1 << '-';

  os << std::hex << std::setfill('0')
     << std::setw(4) << guid.Data2 << '-';

  os << std::hex << std::setfill('0')
     << std::setw(4) << guid.Data3 << '-';

  os << std::hex << std::setfill('0')
     << std::setw(2) << static_cast<short>(guid.Data4[0])
     << std::setw(2) << static_cast<short>(guid.Data4[1])
     << '-'
     << std::setw(2) << static_cast<short>(guid.Data4[2])
     << std::setw(2) << static_cast<short>(guid.Data4[3])
     << std::setw(2) << static_cast<short>(guid.Data4[4])
     << std::setw(2) << static_cast<short>(guid.Data4[5])
     << std::setw(2) << static_cast<short>(guid.Data4[6])
     << std::setw(2) << static_cast<short>(guid.Data4[7]);
  return os;
}
