﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using Microsoft.EntityFrameworkCore.TestModels.JsonQuery;

namespace Microsoft.EntityFrameworkCore.Update;

#nullable disable

public class JsonUpdateSqliteFixture : JsonUpdateFixtureBase
{
    protected override ITestStoreFactory TestStoreFactory
        => SqliteTestStoreFactory.Instance;

    protected override void OnModelCreating(ModelBuilder modelBuilder, DbContext context)
    {
        base.OnModelCreating(modelBuilder, context);

        modelBuilder.Entity<JsonEntityAllTypes>(b =>
        {
            b.Ignore(e => e.TestInt64CollectionCollection);
            b.Ignore(e => e.TestDoubleCollectionCollection);
            b.Ignore(e => e.TestSingleCollectionCollection);
            b.Ignore(e => e.TestBooleanCollectionCollection);
            b.Ignore(e => e.TestCharacterCollectionCollection);
            b.Ignore(e => e.TestDefaultStringCollectionCollection);
            b.Ignore(e => e.TestMaxLengthStringCollectionCollection);
            b.Ignore(e => e.TestInt16CollectionCollection);
            b.Ignore(e => e.TestInt32CollectionCollection);
            b.Ignore(e => e.TestNullableEnumWithIntConverterCollectionCollection);
            b.Ignore(e => e.TestNullableInt32CollectionCollection);
            b.Ignore(e => e.TestNullableEnumCollectionCollection);

            b.OwnsOne(
                e => e.Reference, b =>
                {
                    b.Ignore(e => e.TestInt64CollectionCollection);
                    b.Ignore(e => e.TestDoubleCollectionCollection);
                    b.Ignore(e => e.TestSingleCollectionCollection);
                    b.Ignore(e => e.TestBooleanCollectionCollection);
                    b.Ignore(e => e.TestCharacterCollectionCollection);
                    b.Ignore(e => e.TestDefaultStringCollectionCollection);
                    b.Ignore(e => e.TestMaxLengthStringCollectionCollection);
                    b.Ignore(e => e.TestInt16CollectionCollection);
                    b.Ignore(e => e.TestInt32CollectionCollection);
                    b.Ignore(e => e.TestNullableEnumWithIntConverterCollectionCollection);
                    b.Ignore(e => e.TestNullableInt32CollectionCollection);
                    b.Ignore(e => e.TestNullableEnumCollectionCollection);
                });
            b.OwnsMany(
                x => x.Collection, b =>
                {
                    b.Ignore(e => e.TestInt64CollectionCollection);
                    b.Ignore(e => e.TestDoubleCollectionCollection);
                    b.Ignore(e => e.TestSingleCollectionCollection);
                    b.Ignore(e => e.TestBooleanCollectionCollection);
                    b.Ignore(e => e.TestCharacterCollectionCollection);
                    b.Ignore(e => e.TestDefaultStringCollectionCollection);
                    b.Ignore(e => e.TestMaxLengthStringCollectionCollection);
                    b.Ignore(e => e.TestInt16CollectionCollection);
                    b.Ignore(e => e.TestInt32CollectionCollection);
                    b.Ignore(e => e.TestNullableEnumWithIntConverterCollectionCollection);
                    b.Ignore(e => e.TestNullableInt32CollectionCollection);
                    b.Ignore(e => e.TestNullableEnumCollectionCollection);
                });
        });
    }
}
