package AllSrcBin;
use warnings;
use strict;
use integer;

# Build a complete source hash or binary hash (but don't cross-reference
# or cross-link it yet).
sub new {
  my $class = shift;
  my $self = {};
  bless $self, $class;
  for my $filename ( @_ ) {
    my $fh;
    open $fh, '<', $filename;
      while ( my $pkg = $self->instantiate_one( $fh ) ) {
        my $pname = $pkg->{Package};
        if ( $self->{$pname} ) {
          warn "$0: warning: second listing of $pname ignored\n";
        }
        else { $self->{$pname} = $pkg };
      }
    close $fh;
  }
  return $self;
}

1;

