#ifndef control_file_stream_h_
#define control_file_stream_h_ 1

#include "attribute.hpp"

#include <streambuf>
#include <ios>

class control_file_ostream
{
public:
	inline control_file_ostream(std::streambuf *buf) : buf(buf), state(std::ios::goodbit) { }

	inline std::streambuf *rdbuf(void) { return buf; }

	typedef bool sentry;

	inline operator void const *(void) const
	{
		if(state & (std::ios::badbit|std::ios::failbit))
			return 0;
		return reinterpret_cast<void const *>(1);
	}

private:
	std::streambuf *buf;
	std::ios_base::iostate state;
};

template<typename T>
control_file_ostream &operator<<(control_file_ostream &stream, std::pair<char const *, T> const &item)
{
	control_file_ostream::sentry sentry(stream);
	if(!sentry)
		return stream;
	
	std::string tag = item.first;
	std::string value = attribute_cast<std::string>(item.second);

	std::streambuf &buf = *stream.rdbuf();
	buf.sputn(&tag[0], tag.size());
	buf.sputc(':');
	buf.sputc(' ');
	bool last_was_newline = false;
	for(std::string::iterator i = value.begin(); i != value.end(); ++i)
	{
		if(*i == '\n' && last_was_newline)
			buf.sputc('.');
		buf.sputc(*i);
		if(*i == '\n')
		{
			buf.sputc(' ');
			last_was_newline = true;
		}
		else
			last_was_newline = false;
	}
		
	buf.sputc('\n');
	return stream;
}

class section_break_t { };

control_file_ostream &operator<<(control_file_ostream &, section_break_t);

extern section_break_t section_break;

#endif
