#include "dataoutputstream.h"
#include <netinet/in.h>

namespace rpc {
	
	void DataOutputStream::writeInt(int32 i)
{
		i = htonl(i);
		out->write(&i,4);
}

void DataOutputStream::writeByte(int8 b)
{
	out->write(&b,1);
}

void DataOutputStream::writeShort(int16 s)
{
	s = htons(s);
	out->write(&s,2);
}

void DataOutputStream::writeBool(bool b)
{
	char temp = static_cast<char>(b);
	out->write(&temp,1);
}

void DataOutputStream::writeLong(int64 l)
{
	int l1 = *((int*)&l);
	unsigned int l2 = ((unsigned int*)&l)[1];
	
	l1 = htonl(l1);
	l2 = htonl(l2);
	l = ((int64)l1<<32)+l2;
	out->write(&l,8);
}

void DataOutputStream::writeUTF(const std::string& str)
{
	// length sent is the length of the string, no null termination
	int len = str.size();
	int nlen = htonl(len);
	out->write(&nlen,4);
	out->write(str.c_str(),len);
}

}
